/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqListFragment
extends BaseFaqFragment<FaqPresenter> {
    private String currentSectionId;
    private FaqCardLayoutAdapter mAdapter;

    public static FaqListFragment newInstance(Bundle bundle) {
        FaqListFragment faqFragment = new FaqListFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
        this.currentSectionId = extras.getString("section_id");
    }

    @Override
    protected void initEventAndData(View mView) {
        RelativeLayout rlSearch = (RelativeLayout)this.get("aihelp_rl_search");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlSearch.setBackgroundColor(colorFromHex);
        RecyclerView rvSubSection = (RecyclerView)this.get("aihelp_rv_faq_search");
        rvSubSection.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = new FaqCardLayoutAdapter(this.getContext(), true);
        this.mAdapter.setup(this.getMergedBundle(), this.getFaqFlowListener());
        this.mAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper(){
            final Bundle bundle;
            {
                this.bundle = FaqListFragment.this.getMergedBundle();
            }

            @Override
            public void onIntentToSubSectionOrQuestionList(FaqListEntity faq) {
                this.bundle.putString("section_id", faq.getId());
                this.bundle.putString("section_name", faq.getTitle());
                this.bundle.putString("section_icon", faq.getIconUrl());
                FaqListFragment.this.getFaqFlowListener().onIntentToQuestionList(this.bundle);
            }

            @Override
            public void onIntentToQuestionContent(String faqId, String match) {
                this.bundle.putString("section_id", FaqListFragment.this.currentSectionId);
                this.bundle.putString("faq_main_id", faqId);
                FaqListFragment.this.getFaqFlowListener().onIntentToQuestionContent(this.bundle);
            }
        });
        rvSubSection.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    @Override
    protected void getBundleAfterDataPrepared(@NonNull Bundle extras) {
        String sectionId = extras.getString("section_id");
        ((FaqPresenter)this.mPresenter).goFetchFAQDataSource(sectionId);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_search_faq");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_rv_faq_search");
    }

    @Override
    public void refreshList(List<FaqListEntity> displayFaqList) {
        if (!ListUtil.isListEmpty(displayFaqList)) {
            this.mAdapter.update(displayFaqList);
        } else {
            this.showEmpty(new int[0]);
        }
    }
}

