/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class FaqSearchFragment
extends BaseFaqFragment<FaqPresenter> {
    private RecyclerView rvSearchList;
    private FaqCardLayoutAdapter mSearchAdapter;

    public static FaqSearchFragment newInstance(Bundle bundle) {
        FaqSearchFragment faqFragment = new FaqSearchFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View mView) {
        this.prepareRecyclerView();
    }

    private void prepareRecyclerView() {
        RelativeLayout rlSearch = (RelativeLayout)this.get("aihelp_rl_search");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlSearch.setBackgroundColor(colorFromHex);
        this.rvSearchList = (RecyclerView)this.get("aihelp_rv_faq_search");
        this.rvSearchList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSearchAdapter = new FaqCardLayoutAdapter(this.getContext(), false);
        this.mSearchAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper(){

            @Override
            public void onIntentToQuestionContent(String faqId, String match) {
                SoftInputUtil.hideSoftInput(FaqSearchFragment.this.getContext(), (View)FaqSearchFragment.this.rvSearchList);
                Bundle bundle = FaqSearchFragment.this.getArguments() != null ? FaqSearchFragment.this.getArguments() : new Bundle();
                bundle.putString("faq_main_id", faqId);
                bundle.putString("search_match", match);
                FaqSearchFragment.this.getFaqFlowListener().onIntentToQuestionContent(bundle);
            }
        });
        this.rvSearchList.setAdapter((RecyclerView.Adapter)this.mSearchAdapter);
    }

    public void onQuery(String query) {
        ((FaqPresenter)this.mPresenter).goQueryFAQList(query);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_search_faq");
    }

    @Override
    public void refreshList(List<FaqListEntity> matchedFaqList) {
        if (!this.isVisible()) {
            return;
        }
        if (matchedFaqList != null && matchedFaqList.size() == 0) {
            this.showSearchEmpty();
        } else {
            this.restoreViewState();
        }
        this.mSearchAdapter.update(matchedFaqList);
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_rv_faq_search");
    }
}

