/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.helper.AttachmentDataProvider;
import net.aihelp.ui.helper.AttachmentHelper;
import net.aihelp.ui.helper.AttachmentPickerFile;
import net.aihelp.utils.FileUtil;

public class AttachmentPicker {
    public static final int ATTACHMENT_FILE_NOT_FOUND = -1;
    public static final int UNSUPPORTED_ATTACHMENT_TYPE = -2;
    public static final int ATTACHMENT_FILE_SIZE_LIMIT_EXCEEDED = -3;
    public static final int NO_APPS_TO_OPEN_ATTACHMENTS_INTENT = -4;
    public static final int INVALID_URI = -5;
    private static final long MAX_ATTACHMENT_FILE_SIZE_LIMIT = 0x1900000L;
    private WeakReference<ConversationFragment> attachmentPickerListenerRef;
    private Bundle extraData;
    private int pickType;

    public AttachmentPicker setPickerHost(ConversationFragment fragment) {
        this.attachmentPickerListenerRef = new WeakReference<ConversationFragment>(fragment);
        return this;
    }

    public void launchImagePicker(boolean hasPermission) {
        this.startActivityForResult(AttachmentDataProvider.getIntentForMedia(hasPermission), hasPermission ? 1 : 2);
    }

    public void onAttachmentPickRequestResult(int requestCode, Intent intent) {
        Uri uri = intent.getData();
        switch (requestCode) {
            case 1: {
                this.processUriForAttachment(uri);
                break;
            }
            case 2: {
                Context context = AIHelpContext.getInstance().getContext();
                context.grantUriPermission(context.getPackageName(), uri, 1);
                this.processUriForAttachment(uri);
            }
        }
    }

    private void processUriForAttachment(Uri uri) {
        if (uri != null) {
            Context context = AIHelpContext.getInstance().getContext();
            if (FileUtil.doesFileFromUriExistAndCanRead(uri, context)) {
                AttachmentPickerFile file = AttachmentHelper.createPickFileFromUri(uri);
                Long fileSize = file.originalFileSize;
                long limitSize = Math.max((long)Const.LIMIT_UPLOADING_VIDEO, 0x1900000L);
                if (file.attachmentType == 2 && fileSize != null && fileSize > limitSize || file.attachmentType == 1 && fileSize != null && fileSize > limitSize) {
                    this.sendPickFailure(-3, limitSize);
                } else {
                    this.sendPickSuccess(file, this.extraData);
                }
            } else {
                this.sendPickFailure(-1, null);
            }
        } else {
            this.sendPickFailure(-5, null);
        }
    }

    private void sendPickSuccess(AttachmentPickerFile attachmentPickerFile, Bundle extraData) {
        AttachmentPickerListener attachmentPickerListener = (AttachmentPickerListener)this.attachmentPickerListenerRef.get();
        if (attachmentPickerListener != null) {
            attachmentPickerListener.onPickSuccess(attachmentPickerFile, extraData);
        }
    }

    private void sendPickFailure(int errorCode, Long data) {
        AttachmentPickerListener attachmentPickerListener = (AttachmentPickerListener)this.attachmentPickerListenerRef.get();
        if (attachmentPickerListener != null) {
            attachmentPickerListener.onPickFailure(errorCode, data);
        }
    }

    private void startActivityForResult(Intent intent, int requestCode) {
        try {
            Fragment fragment = (Fragment)this.attachmentPickerListenerRef.get();
            if (fragment != null && fragment.getActivity() != null) {
                fragment.startActivityForResult(intent, requestCode);
            }
        }
        catch (ActivityNotFoundException var4) {
            this.sendPickFailure(-4, null);
        }
    }

    public static AttachmentPicker getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final AttachmentPicker INSTANCE = new AttachmentPicker();

        private LazyHolder() {
        }
    }

    public static interface AttachmentPickerListener {
        public void onPickSuccess(AttachmentPickerFile var1, Bundle var2);

        public void onPickFailure(int var1, Long var2);
    }
}

