/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import android.view.View;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

public class BitmapHelper {
    public static int[] computeSize(String path) {
        int[] size = new int[2];
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        float realWidth = options.outWidth;
        float realHeight = options.outHeight;
        double scale = Math.ceil(Math.max(realHeight, realWidth) / 700.0f);
        if (scale <= 1.0) {
            scale = 1.0;
        }
        size[0] = (int)((double)realWidth / scale);
        size[1] = (int)((double)realHeight / scale);
        TLog.e(String.format("\u5bbd\u9ad8\u4fe1\u606f\u4e3a\uff1a%s -> %s", realWidth + "x" + realHeight, size[0] + "x" + size[1]));
        return size;
    }

    public static Bitmap scaleBitmap(Bitmap origin, int newWidth, int newHeight) {
        if (origin == null) {
            return null;
        }
        try {
            int width = origin.getWidth();
            int height = origin.getHeight();
            float scaleWidth = (float)newWidth / (float)width;
            float scaleHeight = (float)newHeight / (float)height;
            Matrix matrix = new Matrix();
            matrix.postScale(0.8f, 0.9f);
            Bitmap newBM = Bitmap.createBitmap((Bitmap)origin, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
            return newBM;
        }
        catch (Exception e) {
            return origin;
        }
    }

    public static Bitmap scaleBitmap(Bitmap origin, float ratio) {
        if (origin == null) {
            return null;
        }
        int width = origin.getWidth();
        int height = origin.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(ratio, ratio);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)origin, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        if (newBM.equals(origin)) {
            return newBM;
        }
        return newBM;
    }

    public static Bitmap cropBitmap(Bitmap bitmap) {
        int h;
        int w = bitmap.getWidth();
        int cropWidth = w >= (h = bitmap.getHeight()) ? h : w;
        int cropHeight = (int)((double)(cropWidth /= 2) / 1.2);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)(w / 3), (int)0, (int)cropWidth, (int)cropHeight, null, (boolean)false);
    }

    public static Bitmap cropBitmap(Bitmap bitmap, int targetWidth, int targetHeight, boolean cropInCenterY) {
        if (targetWidth <= 0 || targetHeight <= 0) {
            return bitmap;
        }
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int startX = 0;
        if (bitmapWidth > targetWidth) {
            startX = (bitmapWidth - targetWidth) / 2;
        }
        int startY = 0;
        if (cropInCenterY && bitmapHeight > targetHeight) {
            startY = (bitmapHeight - targetHeight) / 2;
        }
        if (startX + targetWidth > bitmapWidth || startY + targetHeight > bitmapHeight) {
            return bitmap;
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)startX, (int)startY, (int)targetWidth, (int)targetHeight, null, (boolean)false);
    }

    public static Bitmap cropBitmapToFitTarget(Bitmap bitmap, View targetView) {
        if (targetView == null) {
            return bitmap;
        }
        return BitmapHelper.cropBitmap(bitmap, targetView.getWidth(), targetView.getHeight(), false);
    }

    public static Bitmap cropBitmapToFitDevice(Bitmap bitmap) {
        Context context = AIHelpContext.getInstance().getContext();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int targetWidth = metrics.widthPixels;
        int targetHeight = metrics.heightPixels;
        return BitmapHelper.cropBitmap(bitmap, targetWidth, targetHeight, false);
    }
}

