/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.cs.ChatHistoryEntity;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.helper.ElvaBotHelper;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConversationHelper {
    private static int sFakeTimeStamp = 10;
    private static final String REGEX_IMAGE = "(http:|https:)(//)((?!\").)*?.(PNG|png|JPG|jpg|JPEG|jpeg)";
    private static final String REGEX_VIDEO = "(http:|https:)(//)((?!\").)*?.(mp4|MP4)";
    private static final String REGEX_RICH_TEXT = "(http:|https:)(//)\\S*?((?=\\s+http)|\\.(PNG|png|JPG|jpg|JPEG|jpeg))|(http:|https:)(//)((?!\").)*";

    public static ConversationMsg getSupportReplyMsg(String response) {
        ConversationMsg conversationMsg = new ConversationMsg();
        conversationMsg.setMessageFromServer(true);
        conversationMsg.setMsgStatus(1003);
        try {
            JSONObject pushReply = new JSONObject(response);
            if (pushReply.has("time")) {
                conversationMsg.setTimeStamp(pushReply.optLong("time"));
            }
            if (pushReply.has("msg")) {
                String msg = pushReply.optString("msg");
                conversationMsg.setMsgContent(msg);
                int msgType = 1;
                if (Pattern.compile(REGEX_IMAGE).matcher(msg).matches()) {
                    msgType = 8;
                } else if (Pattern.compile(REGEX_RICH_TEXT).matcher(msg).find()) {
                    msgType = 10;
                }
                conversationMsg.setMsgType(msgType);
            }
            if (pushReply.has("nickname")) {
                conversationMsg.setNickname(pushReply.optString("nickname"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conversationMsg;
    }

    public static ConversationMsg getUserTextMsg(boolean isBot, String msg) {
        ConversationMsg conversationMsg = new ConversationMsg();
        conversationMsg.setMsgType(isBot ? 3 : 2);
        conversationMsg.setMsgStatus(isBot ? 1003 : 1001);
        conversationMsg.setMsgContent(msg);
        return conversationMsg;
    }

    private static List<ChatHistoryEntity> getChatTimeStampList(JSONObject chatHistory) {
        ArrayList<ChatHistoryEntity> chatTimeStampList = new ArrayList<ChatHistoryEntity>();
        Pattern pattern = Pattern.compile("[0-9]*");
        Iterator keys = chatHistory.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (CustomConfig.CustomerService.isMessageTimestampVisible && "chatTimestamp".equals(key)) {
                ConversationHelper.prepareHistoryTimeStamp(chatTimeStampList, chatHistory.optString("chatTimestamp"));
                continue;
            }
            String[] chatKey = key.split("\\|");
            if (!pattern.matcher(chatKey[0]).matches()) continue;
            ChatHistoryEntity entity = new ChatHistoryEntity();
            entity.setTimeStamp(Long.parseLong(chatKey[0]));
            if (chatKey.length == 2) {
                entity.setMsgType(1);
                entity.setSupportName(chatKey[1]);
                ConversationHelper.prepareSupportNickname(chatHistory, entity);
            } else {
                entity.setMsgType(2);
                entity.setSupportName("");
            }
            chatTimeStampList.add(entity);
        }
        Collections.sort(chatTimeStampList);
        return chatTimeStampList;
    }

    private static void prepareHistoryTimeStamp(ArrayList<ChatHistoryEntity> chatTimeStampList, String chatTimeStamp) {
        String[] timeStampArray;
        if (TextUtils.isEmpty((CharSequence)chatTimeStamp)) {
            return;
        }
        for (String timeStamp : timeStampArray = chatTimeStamp.split(",")) {
            if (!Pattern.compile("[0-9]*").matcher(timeStamp).matches()) continue;
            ChatHistoryEntity entity = new ChatHistoryEntity();
            entity.setMsgType(3);
            entity.setTimeStamp(Long.parseLong(timeStamp) - 1L);
            chatTimeStampList.add(entity);
        }
    }

    private static void prepareSupportNickname(JSONObject chatHistory, ChatHistoryEntity entity) {
        block4: {
            if (chatHistory.has("assigneeinfo")) {
                try {
                    JSONArray jsonArray = new JSONArray(chatHistory.optString("assigneeinfo"));
                    if (jsonArray.length() <= 0) break block4;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        if (!entity.getSupportName().equals(jsonObject.optString("username"))) continue;
                        String nickname = jsonObject.optString("nickname");
                        entity.setSupportNickname(nickname);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getConversationJSONObjectKey(ChatHistoryEntity historyEntity) {
        String key = String.valueOf(historyEntity.getTimeStamp());
        if (!TextUtils.isEmpty((CharSequence)historyEntity.getSupportName())) {
            key = key + "|" + historyEntity.getSupportName();
        }
        return key;
    }

    private static List<ConversationMsg> getSupportMsgAfterLogin(ChatHistoryEntity chatHistoryEntity, String msg) {
        int msgType;
        String textMsg;
        ConversationMsg conversationMsg;
        ArrayList<ConversationMsg> loginMsgList;
        block11: {
            Matcher videoMatcher;
            Matcher imageMatcher;
            block9: {
                block10: {
                    loginMsgList = new ArrayList<ConversationMsg>();
                    conversationMsg = new ConversationMsg();
                    conversationMsg.setTimeStamp(chatHistoryEntity.getTimeStamp());
                    conversationMsg.setMessageFromServer(true);
                    if (TextUtils.isEmpty((CharSequence)msg)) {
                        if (chatHistoryEntity.getMsgType() == 3) {
                            conversationMsg.setMsgType(4);
                            conversationMsg.setMsgStatus(1003);
                            conversationMsg.setMsgContent(String.valueOf(chatHistoryEntity.getTimeStamp()));
                            loginMsgList.add(conversationMsg);
                        }
                        return loginMsgList;
                    }
                    textMsg = msg;
                    imageMatcher = Pattern.compile(REGEX_IMAGE).matcher(msg);
                    videoMatcher = Pattern.compile(REGEX_VIDEO).matcher(msg);
                    if (chatHistoryEntity.getMsgType() != 1) break block9;
                    conversationMsg.setNickname(chatHistoryEntity.getSupportNickname());
                    msgType = 1;
                    if (!Pattern.compile(REGEX_IMAGE).matcher(msg).matches()) break block10;
                    msgType = 8;
                    break block11;
                }
                if (!Pattern.compile(REGEX_RICH_TEXT).matcher(msg).find()) break block11;
                msgType = 10;
                break block11;
            }
            if (imageMatcher.matches()) {
                msgType = 6;
            } else if (videoMatcher.matches()) {
                msgType = 7;
            } else {
                msgType = 2;
                while (imageMatcher.find()) {
                    textMsg = textMsg.replace(imageMatcher.group(), "");
                }
                Matcher newVideoMatcher = Pattern.compile(REGEX_VIDEO).matcher(textMsg);
                while (newVideoMatcher.find()) {
                    textMsg = textMsg.replace(newVideoMatcher.group(), "");
                }
            }
        }
        conversationMsg.setMsgType(msgType);
        conversationMsg.setMsgStatus(1003);
        conversationMsg.setMsgContent(textMsg.replace(";", ""));
        loginMsgList.add(conversationMsg);
        if (conversationMsg.getMsgType() == 2) {
            ConversationHelper.replaceMediaUrls(msg, loginMsgList, conversationMsg);
        }
        return loginMsgList;
    }

    public static List<ConversationMsg> getUserFormMsgList(String msg) {
        ArrayList<ConversationMsg> formMsgList = new ArrayList<ConversationMsg>();
        String textMsg = msg;
        Matcher imageMatcher = Pattern.compile(REGEX_IMAGE).matcher(msg);
        while (imageMatcher.find()) {
            textMsg = textMsg.replace(imageMatcher.group(), "");
        }
        Matcher videoMatcher = Pattern.compile(REGEX_VIDEO).matcher(textMsg);
        while (videoMatcher.find()) {
            textMsg = textMsg.replace(videoMatcher.group(), "");
        }
        ConversationMsg conversationMsg = new ConversationMsg();
        conversationMsg.setMsgType(2);
        conversationMsg.setMsgStatus(1003);
        conversationMsg.setMsgContent(textMsg.replace(";", ""));
        formMsgList.add(conversationMsg);
        ConversationHelper.replaceMediaUrls(msg, formMsgList, conversationMsg);
        return formMsgList;
    }

    private static void replaceMediaUrls(String msg, ArrayList<ConversationMsg> formMsgList, ConversationMsg conversationMsg) {
        String[] messageSplits;
        for (String item : messageSplits = msg.split(";")) {
            Matcher replaceImageMatcher = Pattern.compile(REGEX_IMAGE).matcher(item.trim());
            while (replaceImageMatcher.find()) {
                String imageUrl = replaceImageMatcher.group();
                ConversationMsg formImageMsg = new ConversationMsg();
                formImageMsg.setTimeStamp(conversationMsg.getTimeStamp() + (long)sFakeTimeStamp++);
                formImageMsg.setMessageFromServer(true);
                formImageMsg.setMsgType(6);
                formImageMsg.setMsgStatus(1003);
                formImageMsg.setMsgContent(imageUrl);
                formMsgList.add(formImageMsg);
                msg = msg.replace(imageUrl, "");
            }
            Matcher replaceVideoMatcher = Pattern.compile(REGEX_VIDEO).matcher(msg);
            while (replaceVideoMatcher.find()) {
                String videoUrl = replaceVideoMatcher.group();
                ConversationMsg formVideoMsg = new ConversationMsg();
                formVideoMsg.setTimeStamp(conversationMsg.getTimeStamp() + (long)sFakeTimeStamp++);
                formVideoMsg.setMessageFromServer(true);
                formVideoMsg.setMsgType(7);
                formVideoMsg.setMsgStatus(1003);
                formVideoMsg.setMsgContent(videoUrl);
                formMsgList.add(formVideoMsg);
                msg = msg.replace(videoUrl, "");
            }
        }
    }

    public static List<ConversationMsg> getRetrievedMsgList(JSONObject msgJson) {
        ArrayList<ConversationMsg> list = new ArrayList<ConversationMsg>();
        try {
            if (msgJson != null && msgJson.length() > 0) {
                for (ChatHistoryEntity historyEntity : ConversationHelper.getChatTimeStampList(msgJson)) {
                    String chatMsg = msgJson.optString(ConversationHelper.getConversationJSONObjectKey(historyEntity));
                    list.addAll(ConversationHelper.getSupportMsgAfterLogin(historyEntity, chatMsg));
                }
            }
        }
        catch (Exception e) {
            TLog.e("getRetrievedMsgList, Exception " + e.toString());
        }
        return list;
    }

    public static ElvaBotMsg getDefaultMsg() {
        return ElvaBotHelper.getDefaultReply();
    }

    public static ElvaBotMsg getBotReply(String input) {
        return ElvaBotHelper.getLocalReply(input);
    }

    public static long getWithdrawTimeStamp(String response) {
        try {
            JSONObject pushWithdraw = new JSONObject(response);
            if (pushWithdraw.has("withdrawkey")) {
                return pushWithdraw.getLong("withdrawkey");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
        return 0L;
    }
}

