/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.db.bot.ConversationDBHelper;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.ui.helper.ElvaBotHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginMqttHelper {
    public static List<ConversationMsg> getLoginResponse(String response) {
        ArrayList<ConversationMsg> list = new ArrayList<ConversationMsg>();
        try {
            JSONObject loginObj = new JSONObject(response);
            if (loginObj.has("errorCode")) {
                TLog.e("mqtt login failed, " + response);
                AIHelpLogger.error("MQTT Login failed " + loginObj.toString(), new UnknownError(MqttConfig.getInstance().getMqConfig()));
                return list;
            }
            if (loginObj.has("sdkConfig")) {
                JSONObject sdkConfig = JsonHelper.getJsonObject(loginObj, "sdkConfig");
                CustomConfig.CustomerService.isBotResolveQueryEnable = sdkConfig.optBoolean("isOpenResolveEvaluation");
                CustomConfig.CustomerService.isUnhelpfulFaqStoryNodeEnable = sdkConfig.optBoolean("enableUnhelpfulFaqStoryNode");
            }
            String msgJson = TextUtils.isEmpty((CharSequence)loginObj.optString("chat_private")) ? "{}" : loginObj.optString("chat_private");
            JSONObject chatHistory = new JSONObject(msgJson);
            ResponseMqttHelper.setTicketActive(chatHistory.length() > 0);
            ResponseMqttHelper.setTicketFinished(chatHistory.has("flag"));
            ResponseMqttHelper.setTicketWaitForAskingResolveStatus(chatHistory.has("isShowResolve"));
            ResponseMqttHelper.setTicketWaitForRating(CustomConfig.CustomerService.isTicketRatingEnable);
            ResponseMqttHelper.setAppRatable("yes".equals(chatHistory.optString("storeReview")));
            ResponseMqttHelper.setTicketRejected(chatHistory.optInt("status") == 9);
            if (!(TextUtils.isEmpty((CharSequence)Const.CUSTOM_STORY_NODE) && Const.isLocalWelcomeAvailable || !String.valueOf(1).equals(loginObj.optString("re_type")))) {
                JSONArray msgs = JsonHelper.getJsonArray(loginObj, "msgs");
                switch (loginObj.optInt("contextType")) {
                    case 0: 
                    case 2: {
                        if (msgs.length() > 0) {
                            list.add(ElvaBotHelper.getMqttReply(JsonHelper.getJsonObject(msgs, 0).toString(), true));
                        }
                        ConversationDBHelper.clearElvaMsg();
                    }
                }
            }
            if (String.valueOf(2).equals(loginObj.optString("re_type"))) {
                ConversationMsg defaultWelcomeMsg = new ConversationMsg(1, 1003);
                defaultWelcomeMsg.setTimeStamp(100L);
                defaultWelcomeMsg.setMsgContent(LoginMqttHelper.getWelcomeMessage(loginObj.optString("vip_wlcm_msg")));
                list.add(defaultWelcomeMsg);
                list.addAll(ConversationHelper.getRetrievedMsgList(chatHistory));
            }
            if (loginObj.has("evaluation")) {
                JSONObject jsonObject = new JSONObject(loginObj.optString("evaluation"));
                FeedbackOpinionHelper.INSTANCE.prepareDataSource(JsonHelper.getJsonArray(jsonObject, "detail"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static String getWelcomeMessage(String mqttWelcome) {
        if (!TextUtils.isEmpty((CharSequence)Const.CUSTOM_WELCOME_MSG)) {
            return Const.CUSTOM_WELCOME_MSG;
        }
        if (!TextUtils.isEmpty((CharSequence)CustomConfig.CustomerService.csWelcomeMessage)) {
            return CustomConfig.CustomerService.csWelcomeMessage;
        }
        if (!TextUtils.isEmpty((CharSequence)mqttWelcome)) {
            return mqttWelcome;
        }
        return "How can we help you ?";
    }

    public static JSONObject getLoginParams() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("appId", (Object)Const.APP_ID);
            obj.put("gameId", (Object)Const.APP_ID);
            obj.put("gameUid", (Object)UserProfile.USER_ID);
            if (Const.PRIVACY_POLICY_ACCEPTED) {
                obj.put("userPlayerName", (Object)UserProfile.USER_NAME);
                obj.put("userDisplayName", (Object)UserProfile.USER_NAME);
                obj.put("cmdBaseTime", (Object)Long.toString(System.currentTimeMillis()));
                obj.put("type", MqttConfig.getInstance().getLoginType());
                obj.put("gameInfo", (Object)DeviceInfoUtil.getInstance().getGameInfo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

