/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.cs.storyline.BotOrderInfo;
import net.aihelp.ui.adapter.BillingListAdapter;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public class SendingBillHelper
implements View.OnClickListener {
    private static SendingBillHelper sInstance;
    private AlertDialog billSelectDialog;
    private TextView mTvSend;
    private ImageView mIvClose;
    private RelativeLayout mEmptyLayout;
    private ProgressBar progressBar;
    private ListView mBillList;
    private BillingListAdapter mAdapter;
    private BotOrderInfo botOrderInfo;

    private SendingBillHelper() {
    }

    public static SendingBillHelper getInstance() {
        if (sInstance == null) {
            sInstance = new SendingBillHelper();
        }
        return sInstance;
    }

    public void readyToSelectBill(Context context, BotOrderInfo orderInfo) {
        this.botOrderInfo = orderInfo;
        this.billSelectDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_selecting_bill")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                EventBus.getDefault().unregister(SendingBillHelper.this);
            }
        }).setWidthAndHeight(-1, 500).setHeightByDevice().create();
        LinearLayout llRoot = (LinearLayout)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_ll_bill_dialog"));
        llRoot.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));
        this.mTvSend = (TextView)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_tv_send"));
        Styles.reRenderTextView(this.mTvSend, ResResolver.getString("aihelp_send"), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        this.mTvSend.setOnClickListener((View.OnClickListener)this);
        this.mIvClose = (ImageView)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        Styles.reRenderImageView(this.mIvClose, "aihelp_svg_ic_close_dialog");
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mEmptyLayout = (RelativeLayout)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_rl_empty"));
        this.progressBar = (ProgressBar)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_loading_progress"));
        Drawable drawable = this.progressBar.getIndeterminateDrawable().mutate();
        drawable.setColorFilter(Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor), PorterDuff.Mode.SRC_IN);
        this.progressBar.setIndeterminateDrawable(drawable);
        this.progressBar.setVisibility(0);
        this.mBillList = (ListView)this.billSelectDialog.findViewById(ResResolver.getViewId("aihelp_lv_bill"));
        this.mAdapter = new BillingListAdapter(context, this.mBillList);
        this.mAdapter.setOnOrderCheckedListener(new BillingListAdapter.OnOrderCheckedListener(){

            @Override
            public void onOrderChecked() {
                SendingBillHelper.this.mTvSend.setEnabled(true);
                SendingBillHelper.this.mTvSend.setAlpha(1.0f);
            }
        });
        this.mBillList.setAdapter((ListAdapter)this.mAdapter);
        this.billSelectDialog.show();
        this.requestBillList(context, orderInfo);
        EventBus.getDefault().register(this);
    }

    private void requestBillList(Context context, BotOrderInfo orderInfo) {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", (Object)orderInfo.getId());
            jsonObj.put("userId", (Object)UserProfile.USER_ID);
            jsonObj.put("serverId", (Object)UserProfile.SERVER_ID);
            jsonObj.put("applicationIdentifier", (Object)context.getPackageName());
            if (!TextUtils.isEmpty((CharSequence)orderInfo.getUrl())) {
                AIHelpRequest.getInstance().requestPostByJson(orderInfo.getUrl(), jsonObj, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        SendingBillHelper.this.progressBar.setVisibility(8);
                        try {
                            JSONObject resJsonObject = new JSONObject(result);
                            Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION = resJsonObject.optBoolean("enableInteraction");
                            SendingBillHelper.this.mTvSend.setVisibility(Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION ? 0 : 8);
                            SendingBillHelper.this.mIvClose.setVisibility(Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION ? 8 : 0);
                            JSONArray jsonArray = new JSONArray(resJsonObject.optString("list"));
                            if (jsonArray.length() > 0) {
                                SendingBillHelper.this.mAdapter.update(jsonArray);
                            } else {
                                SendingBillHelper.this.showEmpty(false);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void onFailure(String url, int errorCode, String errorMsg) {
                        SendingBillHelper.this.progressBar.setVisibility(8);
                        SendingBillHelper.this.showEmpty(true);
                    }
                });
            } else {
                this.showEmpty(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showEmpty(boolean isError) {
        this.mTvSend.setVisibility(8);
        this.mIvClose.setVisibility(8);
        this.mEmptyLayout.setVisibility(0);
        TextView tvError = (TextView)this.mEmptyLayout.findViewById(ResResolver.getViewId("aihelp_tv_error_desc"));
        tvError.setText((CharSequence)(isError ? ResResolver.getString("aihelp_data_retrieve_failed") : ResResolver.getString("aihelp_data_not_found_msg")));
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_tv_send") && FastClickValidator.validate() && AppInfoUtil.validateNetwork(v.getContext())) {
            String checkedBillJson = this.mAdapter.getCheckedBill();
            if (!TextUtils.isEmpty((CharSequence)checkedBillJson)) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("userId", (Object)UserProfile.USER_ID);
                    jsonObject.put("userName", (Object)UserProfile.USER_NAME);
                    jsonObject.put("serverId", (Object)UserProfile.SERVER_ID);
                    jsonObject.put("message", (Object)checkedBillJson);
                    if (this.botOrderInfo != null) {
                        jsonObject.put("externalName", (Object)this.botOrderInfo.getName());
                    }
                    AIHelpRequest.getInstance().requestPostByJson(API.GENERATE_NEW_TICKET, jsonObject, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.billSelectDialog != null && this.billSelectDialog.isShowing()) {
                this.billSelectDialog.dismiss();
            }
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_close") && FastClickValidator.validate() && this.billSelectDialog != null && this.billSelectDialog.isShowing()) {
            this.billSelectDialog.dismiss();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (this.billSelectDialog != null && this.billSelectDialog.isShowing()) {
            this.billSelectDialog.dismiss();
        }
    }
}

