/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.init.PrivacyControlEntity;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import org.json.JSONObject;

public class StatisticHelper {
    private static final int TRACK_TYPE_DETAIL_FAQ_OR_ARTICLE = 2;
    private static final int TRACK_TYPE_BOT_FAQ = 6;
    private static final int TRACK_TYPE_FORM_ACTION = 4;
    private static final int TRACK_TYPE_BOT_HISTORY = 11;
    private static final int TRACK_TYPE_BOT_VISIBLE = 5;
    private static final int TRACK_TYPE_BOT_SIMILAR_ANSWER = 3;
    private static final int TRACK_TYPE_SHOW_OPERATION = 21;
    private static final int TRACK_TYPE_SHOW_FAQ = 22;
    private static final int TRACK_TYPE_SEND_CLICK = 31;
    private static final int TRACK_TYPE_OP_ARTICLE_HELPFUL = 34;
    private static final int TRACK_TYPE_OP_ARTICLE_UNHELPFUL = 35;
    private static final int TRACK_TYPE_OP_ARTICLE_VISIBLE = 36;
    public static final int FORM_ACTION_DISPLAYED = 1;
    public static final int FORM_ACTION_CLICKED = 2;
    public static final int FORM_ACTION_SUBMITTED = 3;
    private static Long clickedFormTimeStamp = 0L;

    public static Long getClickedFormTimeStamp() {
        return clickedFormTimeStamp;
    }

    private static boolean isNetworkUnavailable() {
        ConnectivityManager cm = (ConnectivityManager)AIHelpContext.getInstance().getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo == null || !networkInfo.isConnected();
    }

    private static <T> void get(String url, JSONObject params) {
        if (StatisticHelper.isNetworkUnavailable()) {
            return;
        }
        AIHelpRequest.getInstance().requestGetByAsync(url, params, null);
    }

    private static <T> void post(String url, JSONObject params) {
        if (StatisticHelper.isNetworkUnavailable()) {
            return;
        }
        AIHelpRequest.getInstance().requestPostByJson(url, params, null);
    }

    public static void postHelpfulStatus(int faqType, String faqContentId, boolean isHelpful) {
        try {
            if (faqType == 3) {
                JSONObject extData = new JSONObject();
                extData.put("evaluateStatus", isHelpful ? 3 : 4);
                extData.put("kmContentId", (Object)faqContentId);
                StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(isHelpful ? 34 : 35, extData));
            } else {
                JSONObject logMap = new JSONObject();
                logMap.put("id", (Object)faqContentId);
                logMap.put("type1", (Object)(faqType == 1 ? "15" : "4"));
                logMap.put("type2", (Object)(isHelpful ? "5" : "6"));
                logMap.put("language", (Object)Const.CORRECT_LANGUAGE);
                StatisticHelper.post(API.LOG_COUNT_URL, logMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationArticleVisible(String articleId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", (Object)"2");
            extData.put("id", (Object)articleId);
            extData.put("publishId", (Object)articleId);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(2, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationArticleVisibleWithCollectApi(String contentId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("evaluateStatus", 5);
            extData.put("kmContentId", (Object)contentId);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(36, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenFAQDetailVisible(String faqMainId, String faqContentId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", (Object)"1");
            extData.put("publishId", (Object)faqMainId);
            extData.put("id", (Object)faqContentId);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(2, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotFAQClicked(ElvaBotMsg botMsg) {
        try {
            int index;
            String faqContentId = "";
            if (botMsg.isHasUrl() && (index = TextUtils.indexOf((CharSequence)botMsg.getBotUrl().getUrlAddress(), (CharSequence)"?id=")) != -1) {
                faqContentId = botMsg.getBotUrl().getUrlAddress().substring(index + "?id=".length()).replace("&isCustom=1", "");
            }
            JSONObject extData = new JSONObject();
            extData.put("type", (Object)"8");
            extData.put("contentId", (Object)faqContentId);
            extData.put("publishId", (Object)botMsg.getFaqMainId());
            extData.put("createTime", botMsg.getTimeStamp());
            extData.put("isClickDetail", botMsg.isFaqViewed());
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(6, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotFAQGotNegativeFeedback(String createTime, String contentId, String publishId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", (Object)"9");
            extData.put("contentId", (Object)contentId);
            extData.put("publishId", (Object)publishId);
            extData.put("createTime", (Object)createTime);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(6, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenFormEventHappened(long createTime, int type) {
        try {
            if (2 == type) {
                clickedFormTimeStamp = createTime;
            }
            JSONObject extData = new JSONObject();
            extData.put("type", type);
            extData.put("createTime", createTime);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(4, extData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotMessagePrepared(ElvaBotMsg botMsg) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("message", (Object)new JSONObject(botMsg.getRawResponse()));
            extData.put("tags", (Object)JsonHelper.wrap(botMsg.getBotTagList()));
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(11, extData));
            if (botMsg.isSimilarMatched()) {
                extData = new JSONObject();
                extData.put("message", (Object)new JSONObject(botMsg.getRawResponse()));
                extData.put("action", (Object)botMsg.getUserInput());
                StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(3, extData));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotVisible() {
        StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(5, new JSONObject[0]));
    }

    public static void whenAllFAQSectionsVisible(boolean isFromOperation) {
        try {
            JSONObject extendData = new JSONObject();
            extendData.put("source", isFromOperation ? 4 : 0);
            StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(22, extendData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationVisible() {
        StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(21, new JSONObject[0]));
    }

    public static void whenSendButtonClicked() {
        StatisticHelper.post(API.TRACK_COLLECT, StatisticHelper.getCommonParameters(31, new JSONObject[0]));
    }

    private static JSONObject getCommonParameters(int traceType, JSONObject ... extendData) {
        JSONObject map = new JSONObject();
        try {
            map.put("trackType", traceType);
            map.put("language", (Object)Const.CORRECT_LANGUAGE);
            map.put("deviceId", (Object)DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("userId", (Object)UserProfile.USER_ID);
            PrivacyControlEntity entity = CustomConfig.CommonSetting.privacyControlData;
            if (entity != null && entity.getApplicationVersion()) {
                map.put("gameVersion", (Object)AppInfoUtil.getAppVersion(AIHelpContext.getInstance().getContext()));
            }
            if (entity != null && entity.getDeviceModel()) {
                map.put("deviceModel", (Object)Build.MODEL);
            }
            if (entity != null && entity.getOsVersion()) {
                map.put("osVersion", (Object)Build.VERSION.RELEASE);
            }
            if (extendData != null && extendData.length > 0) {
                map.put("extendData", (Object)extendData[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

