/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import java.util.concurrent.atomic.AtomicBoolean;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.op.OperateContentFragment;
import net.aihelp.ui.op.OperationFragment;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;

public class SupportHelper
extends FaqEventListenerWrapper {
    private final Context context;
    private final FragmentManager childFragmentManager;
    private final Bundle bundle;
    private final AtomicBoolean isSupportStarted = new AtomicBoolean();
    private int supportMode;

    public SupportHelper(Context context, FragmentManager childFragmentManager, Bundle bundle) {
        this.context = context;
        this.childFragmentManager = childFragmentManager;
        this.bundle = bundle;
    }

    public void start() {
        if (!this.isSupportStarted.get()) {
            this.supportMode = this.bundle.getInt("support_mode", 0);
            switch (this.supportMode) {
                case 1: {
                    this.startElva(this.bundle, false);
                    break;
                }
                case 2: {
                    this.startConversation(this.bundle, false);
                    break;
                }
                case 3: {
                    this.onIntentToShowSection(this.bundle);
                    break;
                }
                case 4: {
                    this.onIntentToQuestionContent(this.bundle);
                    break;
                }
                case 5: {
                    this.onIntentToOperate(this.bundle);
                    break;
                }
                case 6: {
                    this.onIntentToFillForm(this.bundle, false);
                    break;
                }
                default: {
                    this.onIntentToSectionRoot(this.bundle, false);
                }
            }
            this.isSupportStarted.set(true);
        }
    }

    @Override
    public void onIntentToElvaBot(Bundle bundle) {
        this.startElva(bundle, true);
    }

    @Override
    public void onIntentToConversation(Bundle bundle) {
        this.startConversation(bundle, true);
    }

    public void onIntentToSectionRoot(Bundle bundle, boolean isAddToBackStack) {
        String backStackName = null;
        FaqHomeFragment faqFragment = FaqHomeFragment.newInstance(bundle);
        if (isAddToBackStack) {
            backStackName = faqFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), faqFragment, null, backStackName, false, false);
    }

    private void onIntentToShowSection(Bundle bundle) {
        String sectionId = bundle.getString("section_id", "");
        if (TextUtils.isEmpty((CharSequence)sectionId)) {
            this.onIntentToSectionRoot(bundle, false);
            return;
        }
        this.onIntentToQuestionList(bundle);
    }

    @Override
    public void onIntentToSectionList(Bundle bundle) {
        boolean shouldShowRootSection;
        FaqHomeFragment fraSectionList = FaqHomeFragment.newInstance(bundle);
        boolean bl = shouldShowRootSection = bundle.getString("section_id") == null;
        if (shouldShowRootSection) {
            FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_faq_root"), fraSectionList, null, null, false, false);
        } else {
            FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraSectionList, null, bundle.getString("section_id"), false, false);
        }
    }

    @Override
    public void onIntentToQuestionList(Bundle bundle) {
        String sectionId = bundle.getString("section_id");
        FaqListFragment fraQuestionList = FaqListFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraQuestionList, "", this.getBackStackName(fraQuestionList.getClass().getName()), false, false);
    }

    @Override
    public void onIntentToQuestionContent(Bundle bundle) {
        String faqId = bundle.getString("faq_main_id");
        FaqContentFragment fraQuestionContent = FaqContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraQuestionContent, "", this.getBackStackName(fraQuestionContent.getClass().getName()), true, false);
    }

    @Override
    public void onIntentToSearch(Bundle bundle) {
        Configuration configuration = this.context.getResources().getConfiguration();
        int fragmentContainerId = ResResolver.getViewId("aihelp_support_fragment_container");
        FaqSearchFragment fraSearchFaq = FaqSearchFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, fragmentContainerId, fraSearchFaq, "tag_faq_search", fraSearchFaq.getClass().getName(), false, false);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        FaqSearchFragment searchFragment = (FaqSearchFragment)this.childFragmentManager.findFragmentByTag("tag_faq_search");
        if (searchFragment != null) {
            searchFragment.onQuery(String.valueOf(s).trim());
        }
    }

    private Fragment getTopMostFaqFragment() {
        return FragmentHelper.getTopMostFragment(this.childFragmentManager);
    }

    private String getBackStackName(String backStackName) {
        if (this.supportMode == 3) {
            if (backStackName.equals(FaqContentFragment.class.getName())) {
                return backStackName;
            }
            return "";
        }
        if (this.supportMode == 4) {
            return "";
        }
        return backStackName;
    }

    public void startElva(Bundle bundle, boolean isAddToBackStack) {
        if (MqttConfig.getInstance().isConnected()) {
            return;
        }
        ElvaBotFragment elvaBot = ElvaBotFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = elvaBot.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), elvaBot, backStackName, backStackName, false, false);
    }

    public void startConversation(Bundle bundle, boolean isAddToBackStack) {
        ConversationFragment conversationFragment = ConversationFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = conversationFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), conversationFragment, backStackName, backStackName, false, false);
    }

    @Override
    public void onIntentToFillForm(Bundle bundle, boolean isAddToBackStack) {
        IntentUrlFragment formFragment = IntentUrlFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = formFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), formFragment, backStackName, backStackName, false, false);
    }

    private void onIntentToOperate(Bundle bundle) {
        OperationFragment operateFragment = OperationFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), operateFragment, null, null, false, false);
    }

    @Override
    public void onIntentToOperateContent(Bundle bundle) {
        OperateContentFragment fraOperateContent = OperateContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraOperateContent, "fraOperateContent", fraOperateContent.getClass().getName(), true, false);
    }
}

