/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.op;

import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.logic.OperatePresenter;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class OperateContentFragment
extends BaseFragment<OperatePresenter> {
    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;
    private AIHelpEvaluateView mEvaluateView;

    public static OperateContentFragment newInstance(Bundle bundle) {
        OperateContentFragment faqFragment = new OperateContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        FrameLayout flContent = (FrameLayout)this.get("aihelp_fl_operate_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);
        this.mEvaluateView = (AIHelpEvaluateView)((Object)this.get("aihelp_evaluate_op"));
        this.mProgressBar = (AIHelpWebProgress)((Object)this.get("aihelp_progress_bar"));
        this.mWebView = (AIHelpWebView)((Object)this.get("aihelp_web_view"));
        this.mWebView.setBackgroundColor(0);
        this.mWebView.setWebViewClient(new AIHelpWebViewClient(this.getContext(), this.mProgressBar));
        this.mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, this.mProgressBar));
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        EventBus.getDefault().post(new SupportActionEvent(1002));
        ((OperatePresenter)this.mPresenter).goFetchOperateContent(extras.getString("faq_main_id"));
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_operate_content");
    }

    public void refreshOperateContent(final OperateArticle article) {
        this.mEvaluateView.setMainId(article.getFaqMainId());
        this.mEvaluateView.setContentId(article.getFaqContentId());
        if (CustomConfig.CommonSetting.isEvaluationForOperationEnable && ((OperatePresenter)this.mPresenter).shouldShowEvaluateFooter(article.getFaqMainId())) {
            this.mEvaluateView.setEvaluateState(1);
        } else {
            this.mEvaluateView.setEvaluateState(2);
        }
        this.mEvaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback(){

            @Override
            public void onEvaluated(boolean isHelpful) {
                OperateHelper.INSTANCE.afterArticleEvaluated(article.getFaqMainId());
            }
        });
        String faqContent = DomainSupportHelper.correctDomain(article.getFaqContent());
        int[] colorRGB = Styles.getColorRGB(CustomConfig.CommonSetting.textColor);
        String textColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 1);
        String timeColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 0.3);
        faqContent = faqContent.replace("<body>", String.format("<body style=\"background-color: transparent; %s\">", textColor));
        faqContent = faqContent.replace("<div style='font-size:14px;color:#CCCCCC;'>", String.format("<div style='font-size:14px; %s'>", timeColor));
        this.mWebView.loadDataWithBaseURL(null, faqContent, "text/html", "utf-8", null);
        StatisticHelper.whenOperationArticleVisible(article.getFaqMainId());
        StatisticHelper.whenOperationArticleVisibleWithCollectApi(article.getFaqContentId());
        if (Const.sOperationUnreadListener != null && !((OperatePresenter)this.mPresenter).haveUnreadArticles()) {
            Const.sOperationUnreadListener.onOperationUnreadChanged(false);
        }
    }

    public void onStop() {
        super.onStop();
        this.mProgressBar.hide();
    }

    public boolean onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return false;
        }
        return true;
    }
}

