/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.op;

import android.os.Bundle;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.adapter.OperateListAdapter;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class OperateListFragment
extends BaseFragment {
    private RecyclerView opList;
    private OperateListAdapter operateAdapter;

    public static OperateListFragment getInstance(Bundle bundle) {
        OperateListFragment fraOperateList = new OperateListFragment();
        fraOperateList.setArguments(bundle);
        return fraOperateList;
    }

    @Override
    protected void initEventAndData(View contentView) {
        this.opList = (RecyclerView)this.get("aihelp_rv_operate");
        this.opList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        this.opList.setBackgroundColor(colorFromHex);
        this.operateAdapter = new OperateListAdapter(this.getContext(), new OperateListAdapter.OnOperationFaqClickedListener(){

            @Override
            public void onOperationFaqClicked(String faqId) {
                Bundle bundle = OperateListFragment.this.getArguments();
                if (bundle == null) {
                    bundle = new Bundle();
                }
                bundle.putString("faq_main_id", faqId);
                if (OperateListFragment.this.getFaqFlowListener() != null) {
                    OperateListFragment.this.getFaqFlowListener().onIntentToOperateContent(bundle);
                }
            }
        });
        this.opList.setAdapter((RecyclerView.Adapter)this.operateAdapter);
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        if (extras != null) {
            String sectionId = extras.getString("operate_section");
            List<OperateArticle> articles = OperateHelper.INSTANCE.getOperateArticles(sectionId);
            this.operateAdapter.update(articles, true);
        }
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_operate_list");
    }

    private IFaqEventListener getFaqFlowListener() {
        FragmentManager fragmentManager = this.getFragmentManager();
        for (Fragment fragment : fragmentManager.getFragments()) {
            if (!(fragment instanceof SupportFragment)) continue;
            return ((IFaqParentView)fragment).getFaqEventListener();
        }
        return null;
    }
}

