/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import net.aihelp.config.AIHelpContext;

public class AIHelpWebView
extends WebView {
    public AIHelpWebView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.configureWebView();
        }
    }

    public AIHelpWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.configureWebView();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void configureWebView() {
        WebSettings settings = this.getSettings();
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
        }
        settings.setCacheMode(-1);
        settings.setJavaScriptEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportZoom(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setPluginState(WebSettings.PluginState.ON);
        settings.setUserAgentString(settings.getUserAgentString() + "Rong/2.0");
        settings.setLoadWithOverviewMode(true);
        settings.setBlockNetworkImage(false);
        settings.setAppCacheEnabled(true);
        settings.setAllowFileAccess(true);
        settings.setDomStorageEnabled(true);
        settings.setAppCacheMaxSize(0x800000L);
        settings.setAppCachePath(AIHelpContext.getInstance().getContext().getCacheDir().getAbsolutePath());
        settings.setDatabaseEnabled(true);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

