/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.net.URISyntaxException;
import net.aihelp.common.Const;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

public class AIHelpWebViewClient
extends WebViewClient {
    public static final String TAG = AIHelpWebViewClient.class.getSimpleName();
    private Context context;
    private AIHelpWebProgress webProgress;
    private ShouldOverrideUrlLoadingListener mUrlLoadingListener;
    private OnPageLoadingProgressListener mPageLoadingProgressListener;

    public void setOnPageLoadingProgressListener(OnPageLoadingProgressListener mPageLoadingProgressListener) {
        this.mPageLoadingProgressListener = mPageLoadingProgressListener;
    }

    public void setUrlLoadingListener(ShouldOverrideUrlLoadingListener mUrlLoadingListener) {
        this.mUrlLoadingListener = mUrlLoadingListener;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress) {
        this.context = context;
        this.webProgress = webProgress;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        boolean ret;
        boolean bl = ret = Build.VERSION.SDK_INT >= 24 && this.handleUrlClick(view, request.getUrl().toString()) || super.shouldOverrideUrlLoading(view, request);
        if (this.mUrlLoadingListener != null) {
            this.mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        boolean ret;
        boolean bl = ret = Build.VERSION.SDK_INT < 24 && this.handleUrlClick(view, url) || super.shouldOverrideUrlLoading(view, url);
        if (this.mUrlLoadingListener != null) {
            this.mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.webProgress.show();
        if (this.mPageLoadingProgressListener != null) {
            this.mPageLoadingProgressListener.onPageStarted(view, url);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.mPageLoadingProgressListener != null) {
            this.mPageLoadingProgressListener.onPageFinished(view, url);
        }
    }

    private boolean handleUrlClick(WebView view, String url) {
        Context context = view.getContext();
        if (AppInfoUtil.isNetworkAvailable(context)) {
            if (TextUtils.isEmpty((CharSequence)url)) {
                return true;
            }
            if (url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null) {
                Const.sOnSpecificUrlClickedListener.onSpecificUrlClicked(url);
                return true;
            }
            if (url.startsWith("intent://") || url.startsWith("jsbridge://")) {
                try {
                    Intent intent = Intent.parseUri((String)url, (int)1);
                    if (intent != null) {
                        intent.addCategory("android.intent.category.BROWSABLE");
                        intent.setComponent(null);
                        intent.setSelector(null);
                        PackageManager packageManager = context.getPackageManager();
                        ResolveInfo info = packageManager.resolveActivity(intent, 65536);
                        if (info != null) {
                            context.startActivity(intent);
                        } else {
                            String fallbackUrl = intent.getStringExtra("browser_fallback_url");
                            view.loadUrl(fallbackUrl);
                        }
                        return true;
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ToastUtil.makeRawToast(context, ResResolver.getString("aihelp_network_no_connect"));
            return true;
        }
        return false;
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String message;
        super.onReceivedSslError(view, handler, error);
        switch (error.getPrimaryError()) {
            case 4: {
                message = "SSL_DATE_INVALID";
                break;
            }
            case 1: {
                message = "SSL_EXPIRED";
                break;
            }
            case 2: {
                message = "SSL_IDMISMATCH";
                break;
            }
            case 5: {
                message = "SSL_INVALID";
                break;
            }
            case 0: {
                message = "SSL_NOTYETVALID";
                break;
            }
            case 3: {
                message = "SSL_UNTRUSTED";
                break;
            }
            default: {
                message = "SslError unknown";
            }
        }
        Log.d((String)TAG, (String)("onReceivedSslError: " + message));
    }

    public static interface OnPageLoadingProgressListener {
        public void onPageStarted(WebView var1, String var2);

        public void onPageFinished(WebView var1, String var2);
    }

    public static interface ShouldOverrideUrlLoadingListener {
        public void handleUrlClick(boolean var1);
    }
}

