/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import net.aihelp.utils.SoftInputUtil;

public class AIHelpChatRecyclerView
extends RecyclerView {
    public AIHelpChatRecyclerView(@NonNull Context context) {
        super(context);
    }

    public AIHelpChatRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AIHelpChatRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy < 0 && AIHelpChatRecyclerView.this.isKeyboardShown()) {
                    SoftInputUtil.hideSoftInput(AIHelpChatRecyclerView.this.getContext(), (View)AIHelpChatRecyclerView.this);
                }
            }
        });
    }

    private boolean isKeyboardShown() {
        View rootView = this.getRootView();
        int softKeyboardHeight = 100;
        Rect r = new Rect();
        rootView.getWindowVisibleDisplayFrame(r);
        DisplayMetrics dm = rootView.getResources().getDisplayMetrics();
        int heightDiff = rootView.getBottom() - r.bottom;
        return (float)heightDiff > 100.0f * dm.density;
    }
}

