/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpRatingBar
extends View {
    private Bitmap mFocusedDrawable;
    private Bitmap mUnfocusedDrawable;
    private int mSpacing;
    private int mGradeLevel;
    private int mCurrGrade;
    private int mStarWidth;
    private int mStarHeight;
    private OnStatusChangedListener mListener;

    public int getSelectGrade() {
        return this.mCurrGrade;
    }

    public boolean isFullStar() {
        return this.mCurrGrade == this.mGradeLevel;
    }

    public AIHelpRatingBar(Context context) {
        this(context, null);
    }

    public AIHelpRatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int[] styleable = ResResolver.getStyleable("aihelp_rating_bar");
        if (styleable != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, styleable);
            int focusedResourceId = typedArray.getResourceId(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_focused"), 0);
            int unfocusedResourceId = typedArray.getResourceId(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_unfocused"), 0);
            this.mSpacing = typedArray.getDimensionPixelSize(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_horizontal_spacing"), this.dp2px(15));
            this.mGradeLevel = typedArray.getInt(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_grade_level"), 0);
            this.mCurrGrade = typedArray.getInt(ResResolver.getStyleableFieldIndex("aihelp_rating_bar", "aihelp_rating_bar_default_grade"), this.mGradeLevel);
            if (focusedResourceId == 0 || unfocusedResourceId == 0 || this.mGradeLevel == 0) {
                throw new RuntimeException("Please checkout your xml!");
            }
            typedArray.recycle();
            this.mFocusedDrawable = AIHelpRatingBar.getDrawableBitmap(context, focusedResourceId, Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            this.mUnfocusedDrawable = AIHelpRatingBar.getDrawableBitmap(context, unfocusedResourceId, Styles.getColorWithAlpha(CustomConfig.CommonSetting.highlightedColor, 0.2f));
            this.mStarWidth = this.mFocusedDrawable.getWidth();
            this.mStarHeight = this.mFocusedDrawable.getHeight();
        }
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)0, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.mStarWidth * this.mGradeLevel + this.mSpacing * (this.mGradeLevel - 1);
        int height = this.mStarHeight;
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mFocusedDrawable == null || this.mUnfocusedDrawable == null) {
            return;
        }
        for (int i = 0; i < this.mGradeLevel; ++i) {
            int x = this.mStarWidth * i;
            if (i > 0) {
                x = this.mStarWidth * i + this.mSpacing * i;
            }
            if (this.mCurrGrade > i) {
                canvas.drawBitmap(this.mFocusedDrawable, (float)x, 0.0f, null);
                continue;
            }
            canvas.drawBitmap(this.mUnfocusedDrawable, (float)x, 0.0f, null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: 
            case 2: {
                int currGrade;
                float eventX = event.getX();
                if (eventX < 0.0f) {
                    eventX = 0.0f;
                }
                if ((currGrade = (int)(eventX / (float)(this.mFocusedDrawable.getWidth() + this.mSpacing)) + 1) < 0) {
                    currGrade = 1;
                } else if (currGrade > this.mGradeLevel) {
                    currGrade = this.mGradeLevel;
                }
                if (this.mCurrGrade == currGrade) {
                    return true;
                }
                this.mCurrGrade = currGrade;
                if (this.mListener != null) {
                    this.mListener.onRateStatusChanged(this.mCurrGrade);
                }
                this.invalidate();
            }
        }
        return true;
    }

    public static Bitmap getDrawableBitmap(Context context, int resId, int color) {
        VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)context.getResources(), (int)resId, null);
        if (drawable != null) {
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)color);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public void setOnStatusChangedListener(OnStatusChangedListener mListener) {
        this.mListener = mListener;
    }

    public static interface OnStatusChangedListener {
        public void onRateStatusChanged(int var1);
    }
}

