/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class AIHelpSearchView
extends LinearLayout {
    private boolean isSearchSessionOpen;
    private final EditText editText;
    private final TextView tvCancel;
    private OnAIHelpSearchViewListener mListener;

    public void setupSearchView(OnAIHelpSearchViewListener listener, TextWatcher watcher) {
        this.mListener = listener;
        if (this.editText != null && watcher != null) {
            this.editText.addTextChangedListener(watcher);
        }
    }

    public AIHelpSearchView(Context context) {
        this(context, null);
    }

    public AIHelpSearchView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpSearchView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_search_view"), (ViewGroup)this);
        View searchContainer = this.findViewById(ResResolver.getViewId("aihelp_ll_search"));
        searchContainer.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 999));
        ImageView imageView = (ImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_search"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_search_grey", Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5));
        this.editText = (EditText)this.findViewById(ResResolver.getViewId("aihelp_et_search"));
        Styles.reRenderTextView((TextView)this.editText, CustomConfig.HelpCenter.faqSearchHint);
        this.tvCancel = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_cancel_search"));
        Styles.reRenderTextView(this.tvCancel, ResResolver.getString("aihelp_no"), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!AIHelpSearchView.this.isSearchSessionOpen && hasFocus) {
                    AIHelpSearchView.this.tvCancel.setVisibility(0);
                    AIHelpSearchView.this.isSearchSessionOpen = true;
                    if (AIHelpSearchView.this.mListener != null) {
                        AIHelpSearchView.this.mListener.onFocusChanged();
                    }
                }
            }
        });
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AIHelpSearchView.this.clearInputFocus();
            }
        });
    }

    private void clearInputFocus() {
        this.tvCancel.setVisibility(8);
        this.editText.setText((CharSequence)"");
        this.editText.clearFocus();
        if (this.getContext() != null) {
            SoftInputUtil.hideSoftInput(this.getContext(), (View)this.editText);
        }
        if (this.mListener != null) {
            this.mListener.onInputCanceled();
        }
        this.isSearchSessionOpen = false;
    }

    public void autoFocus() {
        this.editText.setText((CharSequence)"");
        this.editText.requestFocus();
        if (this.getContext() != null) {
            SoftInputUtil.showSoftInput(this.getContext(), (View)this.editText);
        }
    }

    public static interface OnAIHelpSearchViewListener {
        public void onFocusChanged();

        public void onInputCanceled();
    }
}

