/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.common.CustomConfig;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpServiceEntrance
extends RelativeLayout {
    View vNotification;

    public AIHelpServiceEntrance(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_service_entrance"), (ViewGroup)this);
        TextView tvEntrance = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_entrance"));
        tvEntrance.setText((CharSequence)CustomConfig.HelpCenter.faqCSEntranceText);
        tvEntrance.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
        this.vNotification = this.findViewById(ResResolver.getViewId("aihelp_v_unread_status"));
        this.vNotification.setBackground(Styles.getDrawable(Color.parseColor((String)"#FF4747"), 999));
        this.vNotification.setVisibility(8);
        this.updateEntranceStatus(false, false);
    }

    public void setup(Bundle bundle, IFaqEventListener faqEventListener) {
        if (bundle != null && faqEventListener != null) {
            this.updateViewVisibility(bundle);
            this.updateViewClickEvent(bundle, faqEventListener);
        }
    }

    public void updateViewVisibility(Bundle bundle) {
        int supportMoment = bundle.getInt("faq_support_moment", 1001);
        if (supportMoment == 1001) {
            this.updateEntranceStatus(false, false);
            return;
        }
        if (ResponseMqttHelper.isHasUnreadMsg()) {
            this.updateEntranceStatus(true, true);
        } else if (supportMoment == 1002 || ResponseMqttHelper.isTicketActive()) {
            this.updateEntranceStatus(true, false);
        } else {
            switch (supportMoment) {
                case 1003: 
                case 1004: {
                    if (FaqContentFragment.class.getSimpleName().equals(((Object)((Object)this)).getClass().getSimpleName())) break;
                    this.updateEntranceStatus(false, false);
                    break;
                }
                default: {
                    this.updateEntranceStatus(false, false);
                }
            }
        }
    }

    private void updateEntranceStatus(boolean entranceVisible, boolean notificationVisible) {
        if (entranceVisible) {
            this.setVisibility(0);
            this.vNotification.setVisibility(notificationVisible ? 0 : 8);
        } else {
            this.setVisibility(8);
        }
    }

    private void updateViewClickEvent(final Bundle bundle, final IFaqEventListener faqEventListener) {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean skipElva = bundle.getBoolean("skip_elva_in_faq");
                if (skipElva) {
                    bundle.putInt("support_mode", 2);
                    faqEventListener.onIntentToConversation(bundle);
                } else {
                    faqEventListener.onIntentToElvaBot(bundle);
                }
                AIHelpServiceEntrance.this.vNotification.setVisibility(8);
            }
        });
    }
}

