/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import androidx.annotation.RestrictTo;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AppInfoUtil {
    public static String getAppName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appName == null ? "AIHelp" : appName;
    }

    public static String getAppVersion(Context context) {
        if (context == null) {
            return "Context is null!";
        }
        String appVersion = null;
        try {
            String packageName = context.getPackageName();
            PackageInfo p = context.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appVersion;
    }

    public static Intent getLaunchIntent(Context context, String packageName) {
        Intent launchIntentForPackage = null;
        try {
            PackageManager pm = context.getPackageManager();
            launchIntentForPackage = pm.getLaunchIntentForPackage(packageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return launchIntentForPackage;
    }

    public static void goRateApp(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + context.getPackageName())));
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
        } else {
            intent.setData(Uri.parse((String)("https://play.google.com/store/apps/details?id=" + context.getPackageName())));
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
            }
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean validateNetwork(Context context) {
        boolean isAvailable = AppInfoUtil.isNetworkAvailable(context);
        if (!isAvailable) {
            ToastUtil.makeRawToast(context, ResResolver.getString("aihelp_network_no_connect"));
        }
        return isAvailable;
    }
}

