/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RestrictTo;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FileUtil {
    private static final HashSet<String> imageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"));
    private static final Set<String> resizableImageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/x-png", "image/x-citrix-pjpeg", "image/pjpeg"));

    public static boolean isSupportedMimeType(String mimeType) {
        return imageMimeTypes.contains(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(URL url, File saveFile) {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = url.openStream();
            output = new FileOutputStream(saveFile);
            byte[] buffer = new byte[500];
            while ((bytesRead = input.read(buffer, 0, buffer.length)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(input);
                FileUtil.closeQuietly(output);
                throw throwable;
            }
            FileUtil.closeQuietly(input);
            FileUtil.closeQuietly(output);
        }
        FileUtil.closeQuietly(input);
        FileUtil.closeQuietly(output);
    }

    private static void closeQuietly(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMimeType(URL url) {
        try {
            return url.openConnection().getContentType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMimeType(String fileLocation) {
        try {
            return FileUtil.getMimeType(new URL("file://" + fileLocation));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileFromUriExistAndCanRead(Uri uri, Context context) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            boolean bl = parcelFileDescriptor != null;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            TLog.e("doesFileFromUriExistAndCanRead exception " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Bitmap src, File file) {
        if (FileUtil.isEmptyBitmap(src) || !FileUtil.createFileByDeleteOldFile(file)) {
            return false;
        }
        OutputStream os = null;
        boolean ret = false;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            ret = src.compress(Bitmap.CompressFormat.JPEG, 100, os);
            if (!src.isRecycled()) {
                src.recycle();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static boolean isEmptyBitmap(Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    private static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static synchronized String getContentFromFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                RandomAccessFile f = new RandomAccessFile(file, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                f.close();
                return new String(bytes);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean writeFileToDisk(InputStream ins, String filePath) {
        Context context = AIHelpContext.getInstance().getContext();
        try {
            if (context == null) return false;
            File targetFile = new File(filePath);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                byte[] fileReader = new byte[8192];
                inputStream = ins;
                outputStream = new FileOutputStream(targetFile);
                while (true) {
                    int read;
                    if ((read = inputStream.read(fileReader)) == -1) {
                        outputStream.flush();
                        boolean bl = true;
                        return bl;
                    }
                    outputStream.write(fileReader, 0, read);
                }
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return false;
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }
}

