/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.ImageView;
import java.lang.reflect.Method;

public class NavigationBarInfo {
    private static final String TAG = "NavigationBarInfo";
    public static final int VIVO_NOTCH = 32;
    public static final int VIVO_FILLET = 8;

    public static int getNavigationBarHeight(Context context) {
        Resources res;
        int resourceId;
        int result = 0;
        if (NavigationBarInfo.hasNavBar(context) && (resourceId = (res = context.getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        Log.e((String)TAG, (String)("NavigationBarHeight = " + result));
        return result;
    }

    @TargetApi(value=14)
    private static boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            String sNavBarOverride = NavigationBarInfo.getNavBarOverride();
            if ("1".equals(sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        return sNavBarOverride;
    }

    public static void adaptiveStartPage(Activity activity, ImageView imageView, boolean bottom) {
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        float height = dm.heightPixels + NavigationBarInfo.getNavigationBarHeight((Context)activity);
        float width = dm.widthPixels;
        float standard = 1.7777778f;
        float actual = height / width;
        Log.e((String)TAG, (String)("heigth = " + height));
        Log.e((String)TAG, (String)("standard = " + standard));
        Log.e((String)TAG, (String)("actual = " + actual));
    }

    public static void hideNavigationBar(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            View v = activity.getWindow().getDecorView();
            v.setSystemUiVisibility(8);
        } else {
            View decorView = activity.getWindow().getDecorView();
            int uiOptions = 4102;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }

    public static int getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public static boolean hasNotchScreen(Activity activity) {
        return NavigationBarInfo.getInt("ro.miui.notch", activity) || NavigationBarInfo.hasNotchAtHuawei((Context)activity) || NavigationBarInfo.hasNotchAtOPPO((Context)activity) || NavigationBarInfo.hasNotchAtVivo((Context)activity);
    }

    public static boolean getInt(String key, Activity activity) {
        int result = 0;
        if (NavigationBarInfo.isXiaomi()) {
            try {
                ClassLoader classLoader = activity.getClassLoader();
                Class<?> SystemProperties = classLoader.loadClass("android.os.SystemProperties");
                Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
                Method getInt = SystemProperties.getMethod("getInt", paramTypes);
                Object[] params = new Object[]{key, 0};
                result = (Integer)getInt.invoke(SystemProperties, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result == 1;
    }

    public static boolean hasNotchAtHuawei(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> HwNotchSizeUtil = classLoader.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            ret = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"hasNotchAtHuawei ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hasNotchAtHuawei NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"hasNotchAtHuawei Exception");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getNotchSize(Context context) {
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getNotchSize Exception");
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtVivo(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> FtFeature = classLoader.loadClass("android.util.FtFeature");
            Method method = FtFeature.getMethod("isFeatureSupport", Integer.TYPE);
            ret = (Boolean)method.invoke(FtFeature, 32);
            return ret;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"hasNotchAtVivo ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hasNotchAtVivo NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"hasNotchAtVivo Exception");
        }
        finally {
            return ret;
        }
    }

    public static boolean hasNotchAtOPPO(Context context) {
        return context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    public static boolean isXiaomi() {
        return "Xiaomi".equals(Build.MANUFACTURER);
    }

    public static boolean isHuawei() {
        return "Huawei".equals(Build.MANUFACTURER);
    }

    public static boolean isOppo() {
        return "Oppo".equals(Build.MANUFACTURER);
    }

    public static boolean isVivo() {
        return "Vivo".equals(Build.MANUFACTURER);
    }

    public static int getXiaomiNotchHight(Activity activity) {
        int resourceId = activity.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            return activity.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static float getHeight(Activity activity) {
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        if (NavigationBarInfo.hasNotchScreen(activity)) {
            float notchHight = 0.0f;
            if (NavigationBarInfo.isHuawei()) {
                notchHight = NavigationBarInfo.getNotchSize((Context)activity)[1];
            } else if (NavigationBarInfo.isXiaomi()) {
                notchHight = NavigationBarInfo.getXiaomiNotchHight(activity);
            } else if (NavigationBarInfo.isVivo()) {
                notchHight = NavigationBarInfo.getXiaomiNotchHight(activity);
            } else if (NavigationBarInfo.isOppo()) {
                notchHight = NavigationBarInfo.getXiaomiNotchHight(activity);
            }
            return (float)(dm.heightPixels + NavigationBarInfo.getNavigationBarHeight((Context)activity)) - notchHight;
        }
        return dm.heightPixels + NavigationBarInfo.getNavigationBarHeight((Context)activity);
    }
}

