/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.text.TextUtils;
import net.aihelp.config.AIHelpContext;
import net.aihelp.data.localize.data.LocaleStringHelper;

public final class ResResolver {
    private static String removeOneSuffix(String input) {
        if (input == null) {
            return null;
        }
        int lastDotIndex = input.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        return input.substring(0, lastDotIndex);
    }

    private static Class<?> loadClazz(String packageName, String assetType) throws ClassNotFoundException {
        Context context = AIHelpContext.getInstance().getContext();
        return context.getClassLoader().loadClass(packageName + ".R$" + assetType);
    }

    private static Class<?> getCorrectResourceClass(String assetType) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = ResResolver.loadClazz("net.aihelp", assetType);
        }
        catch (ClassNotFoundException ex) {
            String packageName = AIHelpContext.getInstance().getContext().getPackageName();
            try {
                clazz = ResResolver.loadClazz(packageName, assetType);
            }
            catch (ClassNotFoundException e) {
                while (clazz == null) {
                    if ((packageName = ResResolver.removeOneSuffix(packageName)) == null) {
                        throw e;
                    }
                    try {
                        clazz = ResResolver.loadClazz(packageName, assetType);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
        }
        return clazz;
    }

    public static int[] getStyleable(String name) {
        try {
            return (int[])ResResolver.getCorrectResourceClass("styleable").getField(name).get(null);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static int getStyleableFieldIndex(String styleableName, String styleableFieldName) {
        try {
            String name = styleableName + "_" + styleableFieldName;
            return ResResolver.getCorrectResourceClass("styleable").getField(name).getInt(null);
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    public static int getViewId(String name) {
        return ResResolver.getIdentifier(name, "id");
    }

    public static int getLayoutId(String name) {
        return ResResolver.getIdentifier(name, "layout");
    }

    public static int getAnimId(String name) {
        return ResResolver.getIdentifier(name, "anim");
    }

    public static int getColorId(String name) {
        return ResResolver.getIdentifier(name, "color");
    }

    public static int getStringId(String name) {
        return ResResolver.getIdentifier(name, "string");
    }

    public static String getString(String name) {
        String string = LocaleStringHelper.INSTANCE.getString(name);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        Context context = AIHelpContext.getInstance().getContext();
        return context.getResources().getString(ResResolver.getStringId(name));
    }

    public static int getStyleId(String name) {
        return ResResolver.getIdentifier(name, "style");
    }

    public static int getAttrId(String name) {
        return ResResolver.getIdentifier(name, "attr");
    }

    public static int getDrawableId(String name) {
        return ResResolver.getIdentifier(name, "drawable");
    }

    public static int getIdentifier(String name, String assetType) {
        Context context = AIHelpContext.getInstance().getContext();
        int id2 = context.getResources().getIdentifier(name, assetType, context.getPackageName());
        if (id2 != 0) {
            return id2;
        }
        try {
            return ResResolver.getCorrectResourceClass(assetType).getField(name).getInt(null);
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

