/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.RestrictTo;
import java.util.WeakHashMap;
import net.aihelp.config.AIHelpContext;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.ResResolver;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ToastUtil {
    private static Toast toast;
    private static Snackbar snackbar;
    private static WeakHashMap<View, Snackbar> viewToSnackBarMapping;

    public static void makeRawToast(Context context, String text) {
        try {
            if (toast != null) {
                toast.setText((CharSequence)text);
            } else {
                toast = Toast.makeText((Context)context, (CharSequence)text, (int)0);
            }
            toast.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SuppressLint(value={"ShowToast"})
    public static void makeText(Context context, String text, boolean isLong) {
        try {
            View mView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_toast_center_view"), null);
            TextView textView = (TextView)mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
            textView.setText((CharSequence)text);
            if (toast != null) {
                textView.setText((CharSequence)text);
            } else {
                toast = Toast.makeText((Context)context, (CharSequence)text, (int)(isLong ? 1 : 0));
            }
            toast.setView(mView);
            toast.setGravity(17, 0, 0);
            toast.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showSnackBar(View view, String message, boolean isLong) {
        try {
            if (message != null && message.length() != 0) {
                if (view != null) {
                    snackbar = Snackbar.make(view, message, isLong ? 0 : -1);
                    snackbar.show();
                    viewToSnackBarMapping.put(view, snackbar);
                } else {
                    ToastUtil.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void hideSnackBar(View view) {
        try {
            if (view != null) {
                Snackbar snackbar = viewToSnackBarMapping.get(view);
                if (snackbar != null && snackbar.isShown()) {
                    snackbar.dismiss();
                }
                viewToSnackBarMapping.remove(view);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showSnackBar(Activity activity, String message, boolean isLong) {
        try {
            if (snackbar != null && snackbar.isShown()) {
                return;
            }
            if (message != null && message.length() != 0) {
                Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, isLong ? 0 : -1);
                View snackBarView = snackbar.getView();
                snackBarView.setBackgroundColor(-1);
                ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.setActionTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showSnackBar(Activity activity, String message, String action, View.OnClickListener listener) {
        try {
            if (message != null && message.length() != 0) {
                snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, 0).setAction(action, listener);
                View snackBarView = snackbar.getView();
                snackBarView.setBackgroundColor(Color.parseColor((String)"#EFF1F6"));
                ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.setActionTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showRawSnackBar(Activity activity, String message, int duration) {
        try {
            if (message != null && message.length() != 0) {
                if (activity != null) {
                    View contentView = activity.getWindow().getDecorView().findViewById(0x1020002);
                    Snackbar.make(contentView, message, duration).show();
                } else {
                    ToastUtil.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showRawSnackBar(Activity activity, String message, String action, int duration, View.OnClickListener listener) {
        try {
            if (message != null && message.length() != 0) {
                if (activity != null) {
                    View snackBarAction;
                    Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, duration).setAction(action, listener);
                    View snackBarText = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"));
                    if (snackBarText instanceof TextView) {
                        ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"))).setMaxLines(4);
                    }
                    if ((snackBarAction = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))) instanceof TextView) {
                        ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                    }
                    snackbar.show();
                } else {
                    ToastUtil.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        viewToSnackBarMapping = new WeakHashMap();
    }
}

