/*
 * Decompiled with CFR 0.152.
 */
package org.configureme;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.configureme.ConfigurableWrapper;
import org.configureme.Configuration;
import org.configureme.Environment;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.AfterInitialConfiguration;
import org.configureme.annotations.AfterReConfiguration;
import org.configureme.annotations.BeforeConfiguration;
import org.configureme.annotations.BeforeInitialConfiguration;
import org.configureme.annotations.BeforeReConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureAlso;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.configureme.annotations.Set;
import org.configureme.annotations.SetAll;
import org.configureme.annotations.SetIf;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.mbean.ConfigInfo;
import org.configureme.mbean.WatchedConfigFiles;
import org.configureme.mbean.util.MBeanRegisterUtil;
import org.configureme.parser.ConfigurationParser;
import org.configureme.parser.ConfigurationParserException;
import org.configureme.parser.ParsedAttribute;
import org.configureme.parser.ParsedConfiguration;
import org.configureme.parser.json.JsonParser;
import org.configureme.parser.properties.PropertiesParser;
import org.configureme.repository.ArrayValue;
import org.configureme.repository.Artefact;
import org.configureme.repository.CompositeValue;
import org.configureme.repository.ConfigurationRepository;
import org.configureme.repository.IncludeValue;
import org.configureme.repository.PlainValue;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceRegistry;
import org.json.JSONArray;
import org.json.JSONObject;

public enum ConfigurationManager {
    INSTANCE;

    private static final java.util.Set<Class<?>> PLAIN_TYPES;
    private Environment defaultEnvironment = null;
    private ConfigurationSourceKey.Type defaultConfigurationSourceType = ConfigurationSourceKey.Type.FILE;
    private ConfigurationSourceKey.Format defaultConfigurationSourceFormat = ConfigurationSourceKey.Format.JSON;
    private ConcurrentHashMap<ConfigurationSourceKey.Format, ConfigurationParser> parsers;
    private ThreadLocal<Map<String, Map<Environment, Object>>> localCache = new ThreadLocal();
    private static final Class<? extends Annotation>[] CALL_BEFORE_INITIAL_CONFIGURATION;
    private static final Class<? extends Annotation>[] CALL_AFTER_INITIAL_CONFIGURATION;
    private static final Class<? extends Annotation>[] CALL_BEFORE_RE_CONFIGURATION;
    private static final Class<? extends Annotation>[] CALL_AFTER_RE_CONFIGURATION;
    public static final String PROP_NAME_DEFAULT_ENVIRONMENT = "configureme.defaultEnvironment";
    private static final Logger log;

    private ConfigurationManager() {
        MBeanRegisterUtil.regMBean(new WatchedConfigFiles(), new String[0]);
        String defEnvironmentAsString = System.getProperty(PROP_NAME_DEFAULT_ENVIRONMENT, "");
        this.defaultEnvironment = DynamicEnvironment.parse(defEnvironmentAsString);
        this.parsers = new ConcurrentHashMap();
        this.parsers.put(ConfigurationSourceKey.Format.JSON, new JsonParser());
        this.parsers.put(ConfigurationSourceKey.Format.PROPERTIES, new PropertiesParser());
    }

    public boolean isConfigurable(Object o) {
        Class<?> clazz = o.getClass();
        return clazz.isAnnotationPresent(ConfigureMe.class);
    }

    public void configure(Object o) {
        this.configure(o, this.defaultEnvironment);
    }

    public void configure(Object o, ConfigurationSourceKey.Format format) {
        this.configure(o, this.defaultEnvironment, format);
    }

    public void configureAs(Object o, String name) {
        this.configureAs(o, this.defaultEnvironment, name, this.defaultConfigurationSourceFormat);
    }

    public void configureBeanAs(Object o, String name) {
        this.configurePojoAs(o, name);
    }

    public void configureBeanAsIn(Object o, String name, Environment in) {
        this.configurePojoAsIn(o, name, in);
    }

    public void configurePojoAs(Object o, String name) {
        Environment in = this.defaultEnvironment;
        this.configurePojoAsIn(o, name, in);
    }

    public void configurePojoAsIn(Object o, final String name, Environment in) {
        ConfigureMe ann = new ConfigureMe(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ConfigureMe.class;
            }

            @Override
            public boolean watch() {
                return false;
            }

            @Override
            public ConfigurationSourceKey.Type type() {
                return ConfigurationSourceKey.Type.FILE;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public boolean allfields() {
                return true;
            }
        };
        ConfigurationSourceKey configSourceKey = new ConfigurationSourceKey();
        configSourceKey.setFormat(ConfigurationSourceKey.Format.JSON);
        configSourceKey.setType(ann.type());
        configSourceKey.setName(name);
        this.configureInitially(configSourceKey, o, in, ann);
    }

    public void configureAs(Object o, Environment in, String configurationName, ConfigurationSourceKey.Format format) {
        if (!this.isConfigurable(o)) {
            throw new IllegalArgumentException("Class " + o.getClass() + " is not annotated as ConfigureMe, called with: " + o + ", class: " + o.getClass());
        }
        Class<?> clazz = o.getClass();
        ConfigureMe ann = clazz.getAnnotation(ConfigureMe.class);
        ConfigurationSourceKey configSourceKey = new ConfigurationSourceKey();
        configSourceKey.setFormat(format);
        configSourceKey.setType(ann.type());
        configSourceKey.setName(configurationName);
        this.configureAs(o, in, configSourceKey);
    }

    public void configureAs(Object o, Environment in, ConfigurationSourceKey configSourceKey) {
        if (!this.isConfigurable(o)) {
            throw new IllegalArgumentException("Class " + o.getClass() + " is not annotated as ConfigureMe, called with: " + o + ", class: " + o.getClass());
        }
        Class<?> clazz = o.getClass();
        ConfigureMe ann = clazz.getAnnotation(ConfigureMe.class);
        this.configureInitially(configSourceKey, o, in, ann);
    }

    public void configure(Object o, Environment in) {
        this.configure(o, in, this.defaultConfigurationSourceFormat);
    }

    public void configure(Object o, Environment in, ConfigurationSourceKey.Format format) {
        if (!this.isConfigurable(o)) {
            throw new IllegalArgumentException("Class " + o.getClass() + " is not annotated as ConfigureMe, called with: " + o + ", class: " + o.getClass());
        }
        Class<?> clazz = o.getClass();
        String configurationName = "";
        ConfigureMe ann = clazz.getAnnotation(ConfigureMe.class);
        configurationName = ann.name() == null || ann.name().length() == 0 ? ConfigurationManager.extractConfigurationNameFromClassName(clazz) : ann.name();
        this.configureAs(o, in, configurationName, format);
    }

    private void configureInitially(ConfigurationSourceKey key, Object o, Environment in, ConfigureMe ann) {
        this.configure(key, o, in, CALL_BEFORE_INITIAL_CONFIGURATION, CALL_AFTER_INITIAL_CONFIGURATION, ann);
        if (ann.watch()) {
            ConfigurableWrapper wrapper = new ConfigurableWrapper(key, o, in);
            ConfigurationSourceRegistry.INSTANCE.addWatchedConfigurable(wrapper);
            MBeanRegisterUtil.regMBean(new ConfigInfo(key.getName()), key.getName());
        }
    }

    private void callAnnotations(Object configurable, Method[] methods, Class<? extends Annotation>[] annotationClasses) {
        for (Method m : methods) {
            for (Class<? extends Annotation> anAnnotationClass : annotationClasses) {
                Annotation anAnnotation = m.getAnnotation(anAnnotationClass);
                if (anAnnotation == null) continue;
                try {
                    m.invoke(configurable, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("callAnnotations(" + Arrays.toString(methods) + ", " + Arrays.toString(annotationClasses) + ")"), (Throwable)e);
                    throw new AssertionError((Object)("Error declaration in method " + m + ", wrong declaration (public void " + m.getName() + " expected)? - " + e.getMessage()));
                }
                catch (InvocationTargetException e) {
                    log.error((Object)("callAnnotations(Exception in annotated method: " + m + ")"), (Throwable)e);
                    throw new RuntimeException("Exception in annotated method: " + e.getMessage(), e);
                }
            }
        }
    }

    private void configure(ConfigurationSourceKey key, Object o, Environment in, Class<? extends Annotation>[] callBefore, Class<? extends Annotation>[] callAfter, ConfigureMe ann) {
        Class<?> clazz = o.getClass();
        if (ann == null) {
            ann = clazz.getAnnotation(ConfigureMe.class);
        }
        if (ann == null) {
            throw new AssertionError((Object)("An unannotated class shouldn't make it sofar, obj: " + o + " class " + o.getClass()));
        }
        boolean configureAllFields = ann.allfields();
        Configuration configuration = this.getConfiguration(key, in);
        this.configure(configuration, o, callBefore, callAfter, configureAllFields, in);
        if (ann.watch()) {
            for (ConfigurationSourceKey sourceKey : configuration.getExternalConfigurations()) {
                ConfigurableWrapper wrapper = new ConfigurableWrapper(sourceKey, o, in);
                ConfigurationSourceRegistry.INSTANCE.addWatchedConfigurable(wrapper);
                MBeanRegisterUtil.regMBean(new ConfigInfo(sourceKey.getName()), sourceKey.getName());
            }
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("Finished configuration of " + o + " as " + key));
        }
    }

    private void configure(Configuration config, Object o, Class<? extends Annotation>[] callBefore, Class<? extends Annotation>[] callAfter, boolean configureAllFields, Environment environment) {
        this.setCachedObject(config.getName(), environment, o);
        Class<?> clazz = o.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        this.callAnnotations(o, methods, callBefore);
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            String attributeName;
            Value attributeValue;
            if (field.isAnnotationPresent(ConfigureAlso.class)) {
                Object externalConfig = null;
                try {
                    Class<?> externalConfigClass = field.getType();
                    externalConfig = externalConfigClass.newInstance();
                    if (!externalConfigClass.isAnnotationPresent(ConfigureMe.class)) continue;
                    ConfigureMe configureMe = externalConfigClass.getAnnotation(ConfigureMe.class);
                    Object object = this.getCachedObject(configureMe.name(), environment);
                    if (object == null) {
                        INSTANCE.configure(externalConfig, environment);
                        this.setCachedObject(configureMe.name(), environment, externalConfig);
                    } else {
                        externalConfig = object;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Can't create external config task for class name=" + field.getType().getName()));
                }
                if (Modifier.isPublic(field.getModifiers())) {
                    try {
                        field.set(o, externalConfig);
                    }
                    catch (Exception e) {
                        log.warn((Object)(field + ".set(" + o + ", " + externalConfig.toString() + ")"), (Throwable)e);
                    }
                    continue;
                }
                String methodName = "set" + field.getName().toUpperCase().charAt(0) + field.getName().substring(1);
                try {
                    Method method = clazz.getMethod(methodName, field.getType());
                    method.invoke(o, externalConfig);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.error((Object)("can't find method " + methodName + " (" + field.getType() + ")"));
                }
                catch (Exception exception) {
                    log.error((Object)("can't set " + field.getName() + " to " + externalConfig.toString() + ", because: "), (Throwable)exception);
                }
                continue;
            }
            if (!field.isAnnotationPresent(Configure.class) && (!configureAllFields || field.isAnnotationPresent(DontConfigure.class)) || (attributeValue = config.getAttribute(attributeName = field.getName())) == null) continue;
            if (Modifier.isPublic(field.getModifiers())) {
                try {
                    field.set(o, this.resolveValue(field.getType(), attributeValue, callBefore, callAfter, configureAllFields));
                }
                catch (Exception exception) {
                    log.warn((Object)(field + ".set(" + o + ", " + attributeValue + ")"), (Throwable)exception);
                }
                continue;
            }
            String string = "set" + field.getName().toUpperCase().charAt(0) + field.getName().substring(1);
            try {
                Method method = clazz.getMethod(string, field.getType());
                method.invoke(o, this.resolveValue(field.getType(), attributeValue, callBefore, callAfter, configureAllFields));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error((Object)("can't find method " + string + " (" + field.getType() + ")"));
            }
            catch (Exception exception) {
                log.error((Object)("can't set " + attributeName + " to " + attributeValue + ", because: "), (Throwable)exception);
            }
        }
        for (AccessibleObject accessibleObject : methods) {
            java.util.Set<Map.Entry<String, Value>> entries;
            if (accessibleObject.isAnnotationPresent(SetAll.class)) {
                entries = config.getEntries();
                log.debug((Object)("Calling method " + accessibleObject + " with " + entries));
                for (Map.Entry entry : entries) {
                    try {
                        ((Method)accessibleObject).invoke(o, entry.getKey(), this.resolveValue(((Method)accessibleObject).getParameterTypes()[1], (Value)entry.getValue(), callBefore, callAfter, configureAllFields));
                    }
                    catch (Exception exception) {
                        log.warn((Object)(((Method)accessibleObject).getName() + "invoke(" + o + ", " + (String)entry.getKey() + ", " + entry.getValue() + ")"), (Throwable)exception);
                    }
                }
            }
            if (accessibleObject.isAnnotationPresent(SetIf.class)) {
                entries = config.getEntries();
                SetIf setIfAnnotation = ((Method)accessibleObject).getAnnotation(SetIf.class);
                for (Map.Entry entry : entries) {
                    if (!SetIf.ConditionChecker.satisfyCondition(setIfAnnotation, (String)entry.getKey())) continue;
                    log.debug((Object)("Calling method " + accessibleObject + " with parameters : \"" + (String)entry.getKey() + "\", \"" + entry.getValue() + "\""));
                    try {
                        ((Method)accessibleObject).invoke(o, entry.getKey(), this.resolveValue(((Method)accessibleObject).getParameterTypes()[1], (Value)entry.getValue(), callBefore, callAfter, configureAllFields));
                    }
                    catch (Exception e) {
                        log.warn((Object)(((Method)accessibleObject).getName() + "invoke(" + o + ", " + (String)entry.getKey() + ", " + entry.getValue() + ")"), (Throwable)e);
                    }
                }
            }
            if (!accessibleObject.isAnnotationPresent(Set.class)) continue;
            log.debug((Object)("method " + accessibleObject + " is annotated"));
            Set setAnnotation = ((Method)accessibleObject).getAnnotation(Set.class);
            String attributeName = setAnnotation.value();
            Value value = config.getAttribute(attributeName);
            if (value == null) continue;
            log.debug((Object)("setting " + ((Method)accessibleObject).getName() + " to " + value + " configured by " + attributeName));
            try {
                ((Method)accessibleObject).invoke(o, this.resolveValue(((Method)accessibleObject).getParameterTypes()[0], value, callBefore, callAfter, configureAllFields));
            }
            catch (Exception exception) {
                log.warn((Object)(((Method)accessibleObject).getName() + "invoke(" + o + ", " + value + ")"), (Throwable)exception);
            }
        }
        this.callAnnotations(o, methods, callAfter);
    }

    void reconfigure(ConfigurationSourceKey key, Object o, Environment in) {
        this.configure(key, o, in, CALL_BEFORE_RE_CONFIGURATION, CALL_AFTER_RE_CONFIGURATION, null);
    }

    public Configuration getConfiguration(String configurationName) {
        return this.getConfiguration(configurationName, this.defaultEnvironment);
    }

    public Configuration getConfiguration(String configurationName, Environment in) {
        ConfigurationSourceKey configSourceKey = new ConfigurationSourceKey();
        configSourceKey.setFormat(this.defaultConfigurationSourceFormat);
        configSourceKey.setType(this.defaultConfigurationSourceType);
        configSourceKey.setName(configurationName);
        return this.getConfiguration(configSourceKey, in);
    }

    private Configuration getConfiguration(ConfigurationSourceKey configSourceKey, Environment in) {
        String configurationName = configSourceKey.getName();
        if (!ConfigurationRepository.INSTANCE.hasConfiguration(configurationName)) {
            if (!ConfigurationSourceRegistry.INSTANCE.isConfigurationAvailable(configSourceKey)) {
                throw new IllegalArgumentException("No such configuration: " + configurationName + " (" + configSourceKey + ")");
            }
            String content = ConfigurationSourceRegistry.INSTANCE.readConfigurationSource(configSourceKey);
            ConfigurationParser parser = this.parsers.get((Object)configSourceKey.getFormat());
            if (parser == null) {
                throw new IllegalArgumentException("Format " + (Object)((Object)configSourceKey.getFormat()) + " is not supported (yet).");
            }
            ParsedConfiguration pa = null;
            try {
                pa = parser.parseConfiguration(configurationName, content);
            }
            catch (ConfigurationParserException e) {
                log.error((Object)("getConfiguration(" + configurationName + ", " + in + ")"), (Throwable)e);
                throw new IllegalArgumentException(configSourceKey + " is not parseable: " + e.getMessage(), e);
            }
            List<ParsedAttribute<?>> attributes = pa.getAttributes();
            Artefact art = ConfigurationRepository.INSTANCE.createArtefact(configurationName);
            for (String string : pa.getExternalConfigurations()) {
                art.addExternalConfigurations(new ConfigurationSourceKey(this.defaultConfigurationSourceType, this.defaultConfigurationSourceFormat, string));
            }
            for (ParsedAttribute parsedAttribute : attributes) {
                art.addAttributeValue(parsedAttribute.getName(), parsedAttribute.getValue(), parsedAttribute.getEnvironment());
            }
        }
        Configuration config = null;
        config = ConfigurationRepository.INSTANCE.getConfiguration(configurationName, in);
        return config;
    }

    public final void setDefaultEnvironment(Environment anEnvironment) {
        this.defaultEnvironment = anEnvironment;
    }

    public final Environment getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    private static String extractConfigurationNameFromClassName(Class<?> targetClazz) {
        return targetClazz.getName().substring(targetClazz.getName().lastIndexOf(46) + 1).toLowerCase();
    }

    private Object resolveValue(Class<?> valueClass, Value attributeValue, Class<? extends Annotation>[] callBefore, Class<? extends Annotation>[] callAfter, boolean configureAllFields) throws InstantiationException, IllegalAccessException {
        boolean isValueClassDummy;
        boolean isValueClassPlain = ConfigurationManager.isPlain(valueClass);
        boolean bl = isValueClassDummy = valueClass.equals(Object.class) || valueClass.equals(String.class);
        if (attributeValue instanceof PlainValue && !valueClass.isArray() && (isValueClassPlain || isValueClassDummy)) {
            return ConfigurationManager.resolvePlainValue(valueClass, (PlainValue)attributeValue);
        }
        if (attributeValue instanceof CompositeValue && !valueClass.isArray() && (!isValueClassPlain || isValueClassDummy)) {
            return this.resolveCompositeValue(valueClass, (CompositeValue)attributeValue, callBefore, callAfter, configureAllFields);
        }
        if (attributeValue instanceof ArrayValue && (valueClass.isArray() || isValueClassDummy)) {
            return this.resolveArrayValue(valueClass, (ArrayValue)attributeValue, callBefore, callAfter, configureAllFields);
        }
        if (!(!(attributeValue instanceof IncludeValue) || valueClass.isArray() && isValueClassDummy)) {
            return this.resolveValue(valueClass, (Value)attributeValue.getRaw(), callBefore, callAfter, configureAllFields);
        }
        throw new IllegalArgumentException("Can't resolve attribute value " + attributeValue + " to type: " + valueClass.getCanonicalName());
    }

    private static boolean isPlain(Class<?> type) {
        return type.isArray() ? ConfigurationManager.isPlain(type.getComponentType()) : PLAIN_TYPES.contains(type) || Enum.class.isAssignableFrom(type);
    }

    private static Object resolvePlainValue(Class<?> type, PlainValue value) {
        if (type == null) {
            throw new IllegalArgumentException("Checkstyle forced me to do this, apparently type is null which can't happen in resolveValue(null, " + value + ")");
        }
        if (type.equals(String.class) || type.equals(Object.class)) {
            return value.get();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value.get());
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.valueOf(value.get());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(value.get());
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.valueOf(value.get());
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.valueOf(value.get());
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(value.get());
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.valueOf(value.get());
        }
        if (Enum.class.isAssignableFrom(type)) {
            try {
                return type.cast(type.getMethod("valueOf", String.class).invoke(null, value.get()));
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName(), e);
            }
        }
        throw new IllegalArgumentException("Can not resolve '" + value + "' to " + type.getCanonicalName());
    }

    private Object resolveArrayValue(Class<?> valueClass, ArrayValue attributeValue, Class<? extends Annotation>[] callBefore, Class<? extends Annotation>[] callAfter, boolean configureAllFields) throws InstantiationException, IllegalAccessException {
        if (valueClass.equals(Object.class)) {
            return attributeValue.getRaw();
        }
        if (valueClass.equals(String.class)) {
            return new JSONArray((Collection)attributeValue.getRaw()).toString();
        }
        Object resolvedValue = Array.newInstance(valueClass.getComponentType(), attributeValue.get().size());
        for (int i = 0; i < attributeValue.get().size(); ++i) {
            Array.set(resolvedValue, i, this.resolveValue(valueClass.getComponentType(), attributeValue.get().get(i), callBefore, callAfter, configureAllFields));
        }
        return resolvedValue;
    }

    private Object resolveCompositeValue(Class<?> valueClass, CompositeValue attributeValue, Class<? extends Annotation>[] callBefore, Class<? extends Annotation>[] callAfter, boolean configureAllFields) throws InstantiationException, IllegalAccessException {
        if (valueClass.equals(Object.class)) {
            return attributeValue.getRaw();
        }
        if (valueClass.equals(String.class)) {
            return new JSONObject((Map)attributeValue.getRaw()).toString();
        }
        Object resolvedValue = valueClass.newInstance();
        this.configure(attributeValue.get(), resolvedValue, callBefore, callAfter, configureAllFields, this.defaultEnvironment);
        return resolvedValue;
    }

    private Object getCachedObject(String name, Environment environment) {
        Map<Environment, Object> environmentCache;
        Map<String, Map<Environment, Object>> globalCache = this.localCache.get();
        if (globalCache == null) {
            globalCache = new HashMap<String, Map<Environment, Object>>();
            this.localCache.set(globalCache);
        }
        if ((environmentCache = globalCache.get(name)) == null) {
            environmentCache = new HashMap<Environment, Object>();
            globalCache.put(name, environmentCache);
        }
        return environmentCache.get(environment);
    }

    private void setCachedObject(String name, Environment environment, Object o) {
        Map<Environment, Object> environmentCache;
        Map<String, Map<Environment, Object>> globalCache = this.localCache.get();
        if (globalCache == null) {
            globalCache = new HashMap<String, Map<Environment, Object>>();
            this.localCache.set(globalCache);
        }
        if ((environmentCache = globalCache.get(name)) == null) {
            environmentCache = new HashMap<Environment, Object>();
            globalCache.put(name, environmentCache);
        }
        environmentCache.put(environment, o);
    }

    static {
        PLAIN_TYPES = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Boolean.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Byte.class, Byte.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE));
        CALL_BEFORE_INITIAL_CONFIGURATION = new Class[]{BeforeInitialConfiguration.class, BeforeConfiguration.class};
        CALL_AFTER_INITIAL_CONFIGURATION = new Class[]{AfterConfiguration.class, AfterInitialConfiguration.class};
        CALL_BEFORE_RE_CONFIGURATION = new Class[]{BeforeReConfiguration.class, BeforeConfiguration.class};
        CALL_AFTER_RE_CONFIGURATION = new Class[]{AfterConfiguration.class, AfterReConfiguration.class};
        log = Logger.getLogger(ConfigurationManager.class);
    }
}

