/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.environments;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.StringUtils;
import org.configureme.Environment;
import org.configureme.GlobalEnvironment;

public class DynamicEnvironment
implements Environment,
Cloneable {
    private ArrayList<String> elements;

    public DynamicEnvironment() {
        this.elements = new ArrayList();
    }

    public DynamicEnvironment(String start, String ... additional) {
        this();
        this.add(start);
        if (additional != null) {
            for (String s : additional) {
                this.add(s);
            }
        }
    }

    private DynamicEnvironment(List<String> someElements) {
        this.elements = new ArrayList(someElements.size());
        this.elements.addAll(someElements);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (String s : this.elements) {
            if (ret.length() > 0) {
                ret.append("_");
            }
            ret.append(s);
        }
        return ret.toString();
    }

    @Override
    public String expandedStringForm() {
        return this.toString();
    }

    public DynamicEnvironment add(String anElement) {
        this.elements.add(anElement);
        return this;
    }

    public void extendThis(String anElement) {
        this.elements.add(anElement);
    }

    public void reduceThis() {
        if (this.elements == null || this.elements.size() == 0) {
            throw new AssertionError((Object)"Can't reduce this environment");
        }
        this.elements.remove(this.elements.size() - 1);
    }

    public Object clone() {
        try {
            DynamicEnvironment ret = (DynamicEnvironment)super.clone();
            ret.elements = (ArrayList)this.elements.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"cloneable we are!");
        }
    }

    @Override
    public boolean isReduceable() {
        return this.elements != null && this.elements.size() > 0;
    }

    @Override
    public Environment reduce() {
        if (!this.isReduceable()) {
            throw new AssertionError((Object)"Can't reduce unreduceable environment.");
        }
        if (this.elements.size() == 1) {
            return GlobalEnvironment.INSTANCE;
        }
        return new DynamicEnvironment(this.elements.subList(0, this.elements.size() - 1));
    }

    public static Environment parse(String s) {
        if (s == null || s.length() == 0 || s.trim().length() == 0) {
            return GlobalEnvironment.INSTANCE;
        }
        String[] tokens = StringUtils.tokenize((String)s, (char)'_');
        DynamicEnvironment env = new DynamicEnvironment();
        for (String t : tokens) {
            env.add(t);
        }
        return env;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DynamicEnvironment && ((DynamicEnvironment)o).elements.equals(this.elements);
    }

    public int hashCode() {
        return this.elements == null ? 42 : this.elements.hashCode();
    }
}

