/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.mbean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.anotheria.util.StringUtils;
import org.configureme.Configuration;
import org.configureme.ConfigurationManager;
import org.configureme.Environment;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.mbean.ConfigInfoMBean;
import org.configureme.parser.ParsedAttribute;
import org.configureme.parser.json.JsonParser;
import org.configureme.repository.Artefact;
import org.configureme.repository.ConfigurationRepository;
import org.configureme.repository.Value;
import org.json.JSONException;

public class ConfigInfo
implements ConfigInfoMBean {
    private String configName;

    public ConfigInfo(String configName) {
        this.configName = configName;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String showContent() {
        Artefact artefact = ConfigurationRepository.INSTANCE.getArtefact(this.configName);
        if (artefact == null) {
            throw new IllegalArgumentException("No such artefact: " + this.configName);
        }
        Map<Environment, Map<String, Object>> contentMap = artefact.getContent();
        StringBuilder resultContent = new StringBuilder();
        resultContent.append("{\n");
        for (Map.Entry<Environment, Map<String, Object>> environmentMapEntry : contentMap.entrySet()) {
            String env = environmentMapEntry.getKey().expandedStringForm();
            resultContent.append("   ").append(env.isEmpty() ? "" : env + ": ").append("{\n");
            for (Map.Entry<String, Object> stringObjectEntry : environmentMapEntry.getValue().entrySet()) {
                resultContent.append("      ").append(stringObjectEntry.getKey()).append(" : ").append(stringObjectEntry.getValue()).append(",\n");
            }
            resultContent.append("   },\n");
        }
        resultContent.append("}");
        return resultContent.toString();
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        Environment defaultEnvironment = ConfigurationManager.INSTANCE.getDefaultEnvironment();
        Configuration configuration = ConfigurationRepository.INSTANCE.getConfiguration(this.configName, defaultEnvironment);
        Iterator<String> i$ = configuration.getAttributeNames().iterator();
        while (i$.hasNext()) {
            String attrName;
            Value attrValue = configuration.getAttribute(attrName = i$.next());
            attributeMap.put(attrName, attrValue == null ? "" : attrValue.getRaw());
        }
        return attributeMap;
    }

    @Override
    public void setAttributeValue(String attrName, String attrValue) throws JSONException {
        if (StringUtils.isEmpty((String)attrName)) {
            throw new IllegalArgumentException("Please enter attribute name!");
        }
        DynamicEnvironment dynamicEnvironment = (DynamicEnvironment)ConfigurationManager.INSTANCE.getDefaultEnvironment();
        Artefact artefact = ConfigurationRepository.INSTANCE.getArtefact(this.configName);
        if (artefact == null) {
            throw new IllegalArgumentException("No such artefact: " + this.configName);
        }
        List<ParsedAttribute<?>> attList = JsonParser.parse(attrName, attrValue, dynamicEnvironment);
        if (attList == null || attList.isEmpty()) {
            throw new JSONException("Nothing to parse. Please fill out attribute name and value.");
        }
        ParsedAttribute<?> parsedAttribute = attList.get(0);
        artefact.addAttributeValue(attrName, parsedAttribute.getValue(), dynamicEnvironment);
        ConfigurationRepository.INSTANCE.updateArtefact(artefact);
    }
}

