/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.configureme.Configuration;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSourceKey;

public class ConfigurationImpl
implements Configuration {
    private String name;
    private Map<String, Value> attributes;
    private Set<ConfigurationSourceKey> externalConfigurations;

    public ConfigurationImpl(String aName) {
        this.name = aName;
        this.attributes = new ConcurrentHashMap<String, Value>();
        this.externalConfigurations = new HashSet<ConfigurationSourceKey>();
    }

    @Override
    public Set<ConfigurationSourceKey> getExternalConfigurations() {
        return this.externalConfigurations;
    }

    @Override
    public void clearExternalConfigurations() {
        this.externalConfigurations.clear();
    }

    @Override
    public void addExternalConfiguration(ConfigurationSourceKey configurationSourceKey) {
        if (configurationSourceKey == null) {
            return;
        }
        this.externalConfigurations.add(configurationSourceKey);
    }

    @Override
    public Value getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public Set<Map.Entry<String, Value>> getEntries() {
        return this.attributes.entrySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setAttribute(String attributeName, Value attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String toString() {
        return this.getName() + ": " + this.attributes;
    }

    public boolean equals(Object o) {
        return o instanceof ConfigurationImpl && this.name.equals(((ConfigurationImpl)o).name) && this.attributes.equals(((ConfigurationImpl)o).attributes);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }
}

