/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.sources;

public class ConfigurationSourceKey {
    private Type type;
    private Format format;
    private String name;

    public ConfigurationSourceKey() {
    }

    public ConfigurationSourceKey(Type aType, Format aFormat, String aName) {
        this.type = aType;
        this.format = aFormat;
        this.name = aName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getType().toString() + "::" + this.getName() + "::" + (Object)((Object)this.getFormat());
    }

    public boolean equals(Object o) {
        return o instanceof ConfigurationSourceKey ? ((ConfigurationSourceKey)o).type == this.type && ((ConfigurationSourceKey)o).format == this.format && ((ConfigurationSourceKey)o).name.equals(this.name) : false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.format.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public static final ConfigurationSourceKey propertyFile(String name) {
        return new ConfigurationSourceKey(Type.FILE, Format.PROPERTIES, name);
    }

    public static final ConfigurationSourceKey xmlFile(String name) {
        return new ConfigurationSourceKey(Type.FILE, Format.XML, name);
    }

    public static final ConfigurationSourceKey jsonFile(String name) {
        return new ConfigurationSourceKey(Type.FILE, Format.JSON, name);
    }

    public static enum Format {
        JSON,
        PROPERTIES,
        XML;


        public String getExtension() {
            return this.toString().toLowerCase();
        }
    }

    public static enum Type {
        FILE,
        FIXTURE;

    }
}

