/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.sources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.anotheria.util.IOUtils;
import net.anotheria.util.NumberUtils;
import org.apache.log4j.Logger;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.SourceLoader;

public class FileLoader
implements SourceLoader {
    private static final Logger log = Logger.getLogger(FileLoader.class);
    private static final String EXTERNAL_CONF_PATH = "org.configureme.configuration-path";
    private final String externalConfigPath = System.getProperty("org.configureme.configuration-path", null);

    public static final String getFileName(ConfigurationSourceKey source) {
        if (source.getType() != ConfigurationSourceKey.Type.FILE) {
            throw new AssertionError((Object)("Can only load configuration sources with type " + (Object)((Object)ConfigurationSourceKey.Type.FILE)));
        }
        return source.getName() + "." + source.getFormat().getExtension();
    }

    @Override
    public boolean isAvailable(ConfigurationSourceKey key) {
        return this.getFile(key) != null;
    }

    @Override
    public long getLastChangeTimestamp(ConfigurationSourceKey key) {
        File f = this.getFile(key);
        if (f == null) {
            throw new IllegalArgumentException("unable to find configuration with key : " + key);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking timestamp for file: " + f.getAbsolutePath()));
        }
        long ret = f.lastModified();
        if (log.isDebugEnabled()) {
            log.debug((Object)("file " + f.getAbsolutePath() + " last modified is: " + NumberUtils.makeISO8601TimestampString((long)ret)));
        }
        return ret;
    }

    @Override
    public String getContent(ConfigurationSourceKey key) {
        File f = this.getFile(key);
        if (f == null) {
            throw new IllegalArgumentException("unable to find configuration with key : " + key);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("load configuration from file: " + f.getAbsolutePath()));
        }
        try {
            if (!f.exists()) {
                return this.getContentFromJar(f.getName());
            }
            return IOUtils.readFileBufferedAsString((File)f, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error((Object)("getContent(" + key + ")"), (Throwable)e);
            throw new RuntimeException("can't read source: " + key, e);
        }
    }

    private String getContentFromJar(String fileName) throws IOException {
        ClassLoader myLoader = this.getClass().getClassLoader();
        InputStream input = myLoader.getResourceAsStream(fileName);
        return IOUtils.readInputStreamBufferedAsString((InputStream)input, (String)"UTF-8");
    }

    private File getFile(ConfigurationSourceKey key) {
        File f;
        String fileName = FileLoader.getFileName(key);
        if (this.externalConfigPath != null && (f = new File(this.externalConfigPath, fileName)).exists()) {
            return f;
        }
        ClassLoader myLoader = this.getClass().getClassLoader();
        URL url = myLoader.getResource(fileName);
        return url == null ? null : new File(url.getFile());
    }
}

