/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.android;

import android.annotation.TargetApi;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.DexFile;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import net.bytebuddy.dynamic.ClassLoadingStrategy;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.utility.RandomString;

@TargetApi(value=3)
public class AndroidClassLoadingStrategy
implements ClassLoadingStrategy {
    private static final String DEX_CLASS_FILE = "classes.dex";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String EMPTY_LIBRARY_PATH = null;
    private final DexProcessor dexProcessor;
    private final File privateDirectory;
    private final RandomString randomString;

    public AndroidClassLoadingStrategy(File privateDirectory) {
        this(privateDirectory, new DexProcessor.ForSdkCompiler(new DexOptions(), new CfOptions()));
    }

    public AndroidClassLoadingStrategy(File privateDirectory, DexProcessor dexProcessor) {
        if (!privateDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + privateDirectory);
        }
        this.privateDirectory = privateDirectory;
        this.dexProcessor = dexProcessor;
        this.randomString = new RandomString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        DexProcessor.Conversion conversion = this.dexProcessor.create();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            conversion.register(entry.getKey().getName(), entry.getValue());
        }
        File zipFile = new File(this.privateDirectory, this.randomString.nextString() + JAR_FILE_EXTENSION);
        try {
            if (!zipFile.createNewFile()) {
                throw new IllegalStateException("Cannot create " + zipFile);
            }
            JarOutputStream zipOutputStream = new JarOutputStream(new FileOutputStream(zipFile));
            try {
                zipOutputStream.putNextEntry(new JarEntry(DEX_CLASS_FILE));
                conversion.drainTo(zipOutputStream);
                zipOutputStream.closeEntry();
            }
            finally {
                zipOutputStream.close();
            }
            ClassLoader dexClassLoader = this.dexProcessor.makeClassLoader(zipFile, this.privateDirectory, classLoader);
            HashMap loadedTypes = new HashMap(types.size());
            for (TypeDescription typeDescription : types.keySet()) {
                try {
                    loadedTypes.put(typeDescription, dexClassLoader.loadClass(typeDescription.getName()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load " + typeDescription, e);
                }
            }
            HashMap<TypeDescription, Class<?>> hashMap = loadedTypes;
            return hashMap;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write to zip file " + zipFile, e);
        }
        finally {
            if (!zipFile.delete()) {
                Logger.getAnonymousLogger().warning("Could not delete " + zipFile);
            }
        }
    }

    public String toString() {
        return "AndroidClassLoadingStrategy{dexProcessor=" + this.dexProcessor + ", privateDirectory=" + this.privateDirectory + ", randomString=" + this.randomString + '}';
    }

    public static interface DexProcessor {
        public Conversion create();

        public ClassLoader makeClassLoader(File var1, File var2, ClassLoader var3);

        public static class ForSdkCompiler
        implements DexProcessor {
            private static final String CLASS_FILE_EXTENSION = ".class";
            private static final Writer NO_PRINT_OUTPUT = null;
            private static final boolean NOT_VERBOSE = false;
            private final DexOptions dexFileOptions;
            private final CfOptions dexCompilerOptions;

            public ForSdkCompiler(DexOptions dexFileOptions, CfOptions dexCompilerOptions) {
                this.dexFileOptions = dexFileOptions;
                this.dexCompilerOptions = dexCompilerOptions;
            }

            @Override
            public net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion create() {
                return new Conversion(new DexFile(this.dexFileOptions));
            }

            @Override
            public ClassLoader makeClassLoader(File zipFile, File privateDirectory, ClassLoader parentClassLoader) {
                return new DexClassLoader(zipFile.getAbsolutePath(), privateDirectory.getAbsolutePath(), EMPTY_LIBRARY_PATH, parentClassLoader);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.dexCompilerOptions.equals(((ForSdkCompiler)other).dexCompilerOptions) && this.dexFileOptions.equals(((ForSdkCompiler)other).dexFileOptions);
            }

            public int hashCode() {
                int result = this.dexFileOptions.hashCode();
                result = 31 * result + this.dexCompilerOptions.hashCode();
                return result;
            }

            public String toString() {
                return "AndroidClassLoadingStrategy.DexProcessor.ForSdkCompiler{dexFileOptions=" + this.dexFileOptions + ", dexCompilerOptions=" + this.dexCompilerOptions + '}';
            }

            protected class Conversion
            implements net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion {
                private final DexFile dexFile;

                protected Conversion(DexFile dexFile) {
                    this.dexFile = dexFile;
                }

                @Override
                public void register(String name, byte[] binaryRepresentation) {
                    this.dexFile.add(CfTranslator.translate((String)(name.replace('.', '/') + ForSdkCompiler.CLASS_FILE_EXTENSION), (byte[])binaryRepresentation, (CfOptions)ForSdkCompiler.this.dexCompilerOptions, (DexOptions)ForSdkCompiler.this.dexFileOptions));
                }

                @Override
                public void drainTo(OutputStream outputStream) throws IOException {
                    this.dexFile.writeTo(outputStream, NO_PRINT_OUTPUT, false);
                }

                private ForSdkCompiler getOuter() {
                    return ForSdkCompiler.this;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && ForSdkCompiler.this.equals(((Conversion)other).getOuter()) && this.dexFile.equals(((Conversion)other).dexFile);
                }

                public int hashCode() {
                    return this.dexFile.hashCode() + 31 * ForSdkCompiler.this.hashCode();
                }

                public String toString() {
                    return "AndroidClassLoadingStrategy.DexProcessor.ForSdkCompiler.Conversion{dexProcessor=" + ForSdkCompiler.this + ", dexFile=" + this.dexFile + '}';
                }
            }
        }

        public static interface Conversion {
            public void register(String var1, byte[] var2);

            public void drainTo(OutputStream var1) throws IOException;
        }
    }
}

