/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public class MultipleParentClassLoader
extends ClassLoader {
    private final List<? extends ClassLoader> parents;

    public MultipleParentClassLoader(List<? extends ClassLoader> parents) {
        super(null);
        this.parents = parents;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.parents) {
            try {
                return classLoader != null ? classLoader.loadClass(name) : super.loadClass(name);
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        return super.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.parents) {
            URL url = classLoader != null ? classLoader.getResource(name) : super.getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>(this.parents.size() + 1);
        for (ClassLoader classLoader : this.parents) {
            enumerations.add(classLoader != null ? classLoader.getResources(name) : super.getResources(name));
        }
        enumerations.add(super.getResources(name));
        return new CompoundEnumeration(enumerations);
    }

    public String toString() {
        return "MultipleParentClassLoader{parents=" + this.parents + '}';
    }

    public static class Builder {
        private static final int ONLY = 0;
        private final List<ClassLoader> classLoaders;

        public Builder() {
            this(Collections.emptyList());
        }

        private Builder(List<ClassLoader> classLoaders) {
            this.classLoaders = classLoaders;
        }

        public Builder append(Class<?> ... type) {
            return this.append((Collection<Class<?>>)Arrays.asList(type));
        }

        public Builder append(Collection<Class<?>> types) {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(types.size());
            for (Class<?> type : types) {
                classLoaders.add(type.getClassLoader());
            }
            return this.append((List<? extends ClassLoader>)classLoaders);
        }

        public Builder append(ClassLoader ... classLoader) {
            return this.append(Arrays.asList(classLoader));
        }

        public Builder append(List<? extends ClassLoader> classLoaders) {
            return new Builder(ByteBuddyCommons.joinUnique(this.classLoaders, classLoaders));
        }

        public Builder filter(ElementMatcher<? super ClassLoader> matcher) {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this.classLoaders.size());
            for (ClassLoader classLoader : this.classLoaders) {
                if (matcher.matches(classLoader)) continue;
                classLoaders.add(classLoader);
            }
            return new Builder(classLoaders);
        }

        public ClassLoader build() {
            return this.classLoaders.size() == 1 ? this.classLoaders.get(0) : new MultipleParentClassLoader(this.classLoaders);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Builder builder = (Builder)other;
            return this.classLoaders.equals(builder.classLoaders);
        }

        public int hashCode() {
            return this.classLoaders.hashCode();
        }

        public String toString() {
            return "MultipleParentClassLoader.Builder{classLoaders=" + this.classLoaders + '}';
        }
    }

    protected static class CompoundEnumeration
    implements Enumeration<URL> {
        private static final int FIRST = 0;
        private final List<Enumeration<URL>> enumerations;
        private Enumeration<URL> currentEnumeration;

        protected CompoundEnumeration(List<Enumeration<URL>> enumerations) {
            this.enumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentEnumeration != null && this.currentEnumeration.hasMoreElements()) {
                return true;
            }
            if (!this.enumerations.isEmpty()) {
                this.currentEnumeration = this.enumerations.remove(0);
                return this.hasMoreElements();
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (this.hasMoreElements()) {
                return this.currentEnumeration.nextElement();
            }
            throw new NoSuchElementException();
        }

        public String toString() {
            return "MultipleParentClassLoader.CompoundEnumeration{enumerations=" + this.enumerations + ", currentEnumeration=" + this.currentEnumeration + '}';
        }
    }
}

