/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import java.util.ArrayList;

public final class RowColumnVector {
    private int row;
    private int column;
    private int pos;
    private static final RowColumnVector FIRST = new RowColumnVector(1, 1, 0);

    private RowColumnVector(int row, int column, int pos) {
        this.row = row;
        this.column = column;
        this.pos = pos;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getPos() {
        return this.pos;
    }

    public String toString() {
        return this.appendTo(new StringBuffer(20)).toString();
    }

    StringBuffer appendTo(StringBuffer sb) {
        return sb.append('(').append(this.row).append(',').append(this.column).append(':').append(this.pos).append(')');
    }

    static RowColumnVector[] getCacheArray(Source source) {
        int lastSourcePos = source.length() - 1;
        ArrayList<RowColumnVector> list = new ArrayList<RowColumnVector>();
        list.add(FIRST);
        int row = 1;
        for (int pos = 0; pos <= lastSourcePos; ++pos) {
            char ch = source.charAt(pos);
            if (ch != '\n' && (ch != '\r' || pos != lastSourcePos && source.charAt(pos + 1) == '\n')) continue;
            list.add(new RowColumnVector(++row, 1, pos + 1));
        }
        return list.toArray(new RowColumnVector[list.size()]);
    }

    static RowColumnVector get(RowColumnVector[] cacheArray, int pos) {
        RowColumnVector rowColumnVector;
        int low = 0;
        int high = cacheArray.length - 1;
        while (true) {
            int mid = low + high >> 1;
            rowColumnVector = cacheArray[mid];
            if (rowColumnVector.pos < pos) {
                if (mid == high) {
                    return new RowColumnVector(rowColumnVector.row, pos - rowColumnVector.pos + 1, pos);
                }
                low = mid + 1;
                continue;
            }
            if (rowColumnVector.pos <= pos) break;
            high = mid - 1;
        }
        return rowColumnVector;
    }
}

