/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.HTMLElementTerminatingTagNameSets;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.MasonTagTypes;
import au.id.jericho.lib.html.PHPTagTypes;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;
    private Element element = null;

    StartTag(Source source, int begin, int end, StartTagType startTagType, String name, Attributes attributes) {
        super(source, begin, end, name);
        this.attributes = attributes;
        this.startTagType = startTagType;
    }

    public boolean isEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes == null ? null : this.attributes.getValue(attributeName);
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int maxErrorCount) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int maxEnd = this.end - this.startTagType.getClosingDelimiter().length();
        int attributesBegin = this.begin + 1 + this.name.length();
        while (!Tag.isXMLNameStartChar(this.source.charAt(attributesBegin))) {
            if (++attributesBegin != maxEnd) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, attributesBegin, maxEnd, this.startTagType, this.name, maxErrorCount);
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public Element getElement() {
        if (this.element == null) {
            this.element = new Element(this.source, this, this.findEndTagInternal());
        }
        return this.element;
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isEmptyElementTag();
    }

    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    public String regenerateHTML() {
        if (this.attributes == null) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(this.name);
        this.attributes.appendRegeneratedHTML(sb);
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            sb.append(" /");
        }
        sb.append(this.startTagType.getClosingDelimiter());
        return sb.toString();
    }

    public static String generateHTML(String tagName, Map attributesMap, boolean emptyElementTag) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer sb = stringWriter.getBuffer();
        sb.append('<').append(tagName);
        try {
            Attributes.appendHTML(stringWriter, attributesMap);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (emptyElementTag) {
            sb.append(" />");
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append('\"').append(this.name).append("\" ");
        if (this.startTagType != StartTagType.NORMAL) {
            sb.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    public boolean isEndTagOptional() {
        return this.getStartTagType() == StartTagType.NORMAL && HTMLElements.getEndTagOptionalElementNames().contains(this.name);
    }

    public EndTag findEndTag() {
        return this.getElement().getEndTag();
    }

    public FormControlType getFormControlType() {
        FormControl formControl = this.getFormControl();
        if (formControl == null) {
            return null;
        }
        return formControl.getFormControlType();
    }

    public Segment getFollowingTextSegment() {
        int endData = this.source.getParseText().indexOf('<', this.end);
        if (endData == -1) {
            endData = this.source.length();
        }
        return new Segment(this.source, this.end, endData);
    }

    public boolean isServerTag() {
        return this.getTagType().isServerTag();
    }

    public boolean isComment() {
        return this.startTagType == StartTagType.COMMENT;
    }

    public boolean isProcessingInstruction() {
        return this.charAt(1) == '?';
    }

    public boolean isXMLDeclaration() {
        return this.startTagType == StartTagType.XML_DECLARATION;
    }

    public boolean isDocTypeDeclaration() {
        return this.startTagType == StartTagType.DOCTYPE_DECLARATION;
    }

    public boolean isCommonServerTag() {
        return this.startTagType == StartTagType.SERVER_COMMON;
    }

    public boolean isPHPTag() {
        return this.startTagType == PHPTagTypes.PHP_STANDARD;
    }

    public boolean isMasonTag() {
        return this.startTagType == StartTagType.SERVER_COMMON || this.startTagType == MasonTagTypes.MASON_NAMED_BLOCK || this.startTagType == MasonTagTypes.MASON_COMPONENT_CALL || this.startTagType == MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    public boolean isMasonNamedBlock() {
        return this.startTagType == MasonTagTypes.MASON_NAMED_BLOCK;
    }

    public boolean isMasonComponentCall() {
        return this.startTagType == MasonTagTypes.MASON_COMPONENT_CALL;
    }

    public boolean isMasonComponentCalledWithContent() {
        return this.startTagType == MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    private EndTag findEndTagInternal() {
        Segment[] findResult;
        EndTag nextEndTag;
        if (this.startTagType == StartTagType.NORMAL) {
            HTMLElementTerminatingTagNameSets terminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(this.name);
            if (terminatingTagNameSets != null) {
                return this.findOptionalEndTag(terminatingTagNameSets);
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name) || this.isEmptyElementTag() && !HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
                return null;
            }
        } else if (this.startTagType.getCorrespondingEndTagType() == null) {
            return null;
        }
        if ((nextEndTag = this.source.findNextEndTag(this.end, this.name, this.startTagType.getCorrespondingEndTagType())) != null && (findResult = this.findEndTag(nextEndTag)) != null) {
            return (EndTag)findResult[0];
        }
        this.source.log("StartTag", null, this.begin, "missing required end tag", -1);
        return null;
    }

    private EndTag findOptionalEndTag(HTMLElementTerminatingTagNameSets terminatingTagNameSets) {
        Iterator i = Tag.getNextTagIterator(this.source, this.end);
        while (i.hasNext()) {
            Set terminatingTagNameSet;
            Tag tag = (Tag)i.next();
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                terminatingTagNameSet = terminatingTagNameSets.NonterminatingElementNameSet;
                if (terminatingTagNameSet != null && terminatingTagNameSet.contains(tag.name)) {
                    Element nonterminatingElement = ((StartTag)tag).getElement();
                    i = Tag.getNextTagIterator(this.source, nonterminatingElement.end);
                    continue;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (terminatingTagNameSet == null || !terminatingTagNameSet.contains(tag.name)) continue;
            return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static StartTag findPreviousOrNext(Source source, int pos, String searchName, boolean previous) {
        if (searchName == null) {
            return StartTag.findPreviousOrNext(source, pos, previous);
        }
        if (searchName.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        char[] startDelimiterCharArray = new char[searchName.length() + 1];
        startDelimiterCharArray[0] = 60;
        for (int i = 1; i < startDelimiterCharArray.length; ++i) {
            startDelimiterCharArray[i] = searchName.charAt(i - 1);
        }
        if (startDelimiterCharArray[1] == '/') {
            throw new IllegalArgumentException("searchName argument \"" + searchName + "\" must not start with '/'");
        }
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                char lastSearchNameChar;
                int n = begin = previous ? parseText.lastIndexOf(startDelimiterCharArray, begin) : parseText.indexOf(startDelimiterCharArray, begin);
                if (begin == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, begin);
                if (startTag == null || startTag.startTagType.isNameAfterPrefixRequired() && startTag.name.length() > searchName.length() && (lastSearchNameChar = searchName.charAt(searchName.length() - 1)) != ':' && Tag.isXMLNameChar(lastSearchNameChar)) continue;
                return startTag;
            } while (Tag.inRange(source, begin += previous ? -2 : 1));
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    private static StartTag findPreviousOrNext(Source source, int pos, boolean previous) {
        Tag tag;
        while ((tag = Tag.findPreviousOrNextTag(source, pos, previous)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            pos += previous ? -1 : 1;
        }
        return null;
    }

    static StartTag findNext(Source source, int pos, String attributeName, String value, boolean valueCaseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        char[] valueCharArray = value.toLowerCase().toCharArray();
        ParseText parseText = source.getParseText();
        while (pos < source.end) {
            String attributeValue;
            if ((pos = parseText.indexOf(valueCharArray, pos)) == -1) {
                return null;
            }
            Tag tag = source.findEnclosingTag(pos);
            if (tag == null || !(tag instanceof StartTag)) {
                ++pos;
                continue;
            }
            StartTag startTag = (StartTag)tag;
            if (startTag.getAttributes() != null && (attributeValue = startTag.getAttributes().getValue(attributeName)) != null) {
                if (value.equals(attributeValue)) {
                    return startTag;
                }
                if (value.equalsIgnoreCase(attributeValue)) {
                    if (!valueCaseSensitive) {
                        return startTag;
                    }
                    source.log(pos, "StartTag with attribute " + attributeName + "=\"" + attributeValue + "\" ignored during search because its case does not match search value \"" + value + '\"');
                }
            }
            pos = startTag.end + 5;
        }
        return null;
    }

    private Segment[] findEndTag(EndTag nextEndTag) {
        return this.findEndTag(this.end, this.source.findNextStartTag(this.end, this.name), nextEndTag);
    }

    private Segment[] findEndTag(int afterPos, StartTag nextStartTag, EndTag nextEndTag) {
        if (nextEndTag == null) {
            return null;
        }
        Segment[] returnArray = new Segment[]{nextEndTag, nextStartTag};
        if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
            return returnArray;
        }
        Segment[] findResult = nextStartTag.findEndTag(nextEndTag);
        if (findResult == null) {
            return null;
        }
        EndTag nextStartTagsEndTag = (EndTag)findResult[0];
        nextStartTag = (StartTag)findResult[1];
        nextEndTag = this.source.findNextEndTag(nextStartTagsEndTag.end, this.name);
        return this.findEndTag(nextStartTagsEndTag.end, nextStartTag, nextEndTag);
    }
}

