/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagTypeGenericImplementation;
import au.id.jericho.lib.html.Tag;

class StartTagTypeMarkupDeclaration
extends StartTagTypeGenericImplementation {
    static final StartTagTypeMarkupDeclaration INSTANCE = new StartTagTypeMarkupDeclaration();
    static final String ELEMENT = "!element";
    static final String ATTLIST = "!attlist";
    static final String ENTITY = "!entity";
    static final String NOTATION = "!notation";

    private StartTagTypeMarkupDeclaration() {
        super("markup declaration", "<!", ">", null, false, false, true);
    }

    protected Tag constructTagAt(Source source, int pos) {
        Tag tag = super.constructTagAt(source, pos);
        if (tag == null) {
            return null;
        }
        String name = tag.getName();
        if (name != ELEMENT && name != ATTLIST && name != ENTITY && name != NOTATION) {
            return null;
        }
        return tag;
    }

    protected int findEnd(Source source, int pos) {
        ParseText parseText = source.getParseText();
        boolean insideQuotes = false;
        do {
            char c;
            if ((c = parseText.charAt(pos)) == '\"') {
                insideQuotes = !insideQuotes;
                continue;
            }
            if (c != '>' || insideQuotes) continue;
            return pos + 1;
        } while (++pos < source.length());
        return -1;
    }
}

