/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html.nodoc;

import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class SequentialListSegment
extends Segment
implements List {
    public SequentialListSegment(Source source, int begin, int end) {
        super(source, begin, end);
    }

    public abstract int getCount();

    public abstract ListIterator listIterator(int var1);

    public Object get(int index) {
        ListIterator li = this.listIterator(index);
        try {
            return li.next();
        }
        catch (NoSuchElementException ex) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
    }

    public int size() {
        return this.getCount();
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.getCount()];
        int x = 0;
        ListIterator li = this.listIterator(0);
        while (li.hasNext()) {
            array[x++] = li.next();
        }
        return array;
    }

    public Object[] toArray(Object[] a) {
        int count = this.getCount();
        if (a.length < count) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), count);
        }
        int x = 0;
        ListIterator li = this.listIterator(0);
        while (li.hasNext()) {
            a[x++] = li.next();
        }
        if (a.length > count) {
            a[count] = null;
        }
        return a;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        ListIterator li = this.listIterator(0);
        if (o == null) {
            while (li.hasNext()) {
                if (li.next() != null) continue;
                return li.previousIndex();
            }
        } else {
            while (li.hasNext()) {
                if (!o.equals(li.next())) continue;
                return li.previousIndex();
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        ListIterator li = this.listIterator(this.getCount());
        if (o == null) {
            while (li.hasPrevious()) {
                if (li.previous() != null) continue;
                return li.nextIndex();
            }
        } else {
            while (li.hasPrevious()) {
                if (!o.equals(li.previous())) continue;
                return li.nextIndex();
            }
        }
        return -1;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    private static class SubList
    extends AbstractList {
        private final List list;
        private final int offset;
        private final int size;

        SubList(List list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex=" + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex=" + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.list = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        public Object get(int index) {
            return this.list.get(this.getSuperListIndex(index));
        }

        public int size() {
            return this.size;
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                private final ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ SubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.i = SubList.access$100(this.this$0).listIterator(SubList.access$000(this.this$0, this.val$index));
                }

                public boolean hasNext() {
                    return this.nextIndex() < SubList.access$200(this.this$0);
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                public Object previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - SubList.access$300(this.this$0);
                }

                public int previousIndex() {
                    return this.i.previousIndex() - SubList.access$300(this.this$0);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object o) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new SubList(this, fromIndex, toIndex);
        }

        private int getSuperListIndex(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
            }
            return index + this.offset;
        }

        static /* synthetic */ int access$000(SubList x0, int x1) {
            return x0.getSuperListIndex(x1);
        }

        static /* synthetic */ List access$100(SubList x0) {
            return x0.list;
        }

        static /* synthetic */ int access$200(SubList x0) {
            return x0.size;
        }

        static /* synthetic */ int access$300(SubList x0) {
            return x0.offset;
        }
    }
}

