/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.reflect.Method;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.spring.annotation.LockProviderToUse;
import net.javacrumbs.shedlock.spring.aop.LockProviderSupplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.core.annotation.AnnotationUtils;

class BeanNameSelectingLockProviderSupplier
implements LockProviderSupplier {
    private final ListableBeanFactory beanFactory;

    BeanNameSelectingLockProviderSupplier(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public LockProvider supply(@Nullable Object target, Method method, @Nullable Object[] parameterValues) {
        LockProviderToUse annotation = this.findAnnotation(target, method);
        if (annotation == null) {
            throw this.noUniqueBeanDefinitionException();
        }
        return (LockProvider)this.beanFactory.getBean(annotation.value(), LockProvider.class);
    }

    private NoUniqueBeanDefinitionException noUniqueBeanDefinitionException() {
        Map lockProviders = this.beanFactory.getBeansOfType(LockProvider.class);
        return new NoUniqueBeanDefinitionException(LockProvider.class, lockProviders.size(), "Multiple LockProviders found (" + String.join((CharSequence)", ", lockProviders.keySet()) + "), use @LockProviderToUse to disambiguate.");
    }

    private @Nullable LockProviderToUse findAnnotation(@Nullable Object target, Method method) {
        LockProviderToUse annotation = (LockProviderToUse)AnnotationUtils.findAnnotation((Method)method, LockProviderToUse.class);
        if (annotation != null) {
            return annotation;
        }
        if (target != null && (annotation = (LockProviderToUse)AnnotationUtils.findAnnotation(target.getClass(), LockProviderToUse.class)) != null) {
            return annotation;
        }
        return method.getDeclaringClass().getPackage().getAnnotation(LockProviderToUse.class);
    }
}

