/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.lang3.StringUtils;

public class TagsOverviewPage
extends AbstractPage {
    private static final NumberFormat DECIMAL_FORMATTER = DecimalFormat.getInstance(Locale.US);
    public static final String WEB_PAGE = "tag-overview.html";

    public TagsOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "tagsOverview.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return WEB_PAGE;
    }

    @Override
    public void prepareReport() {
        List<TagObject> tags = this.report.getAllTags();
        this.context.put("all_tags", tags);
        this.context.put("report_summary", (Object)this.report.getTagReport());
        this.context.put("chart_categories", (Object)TagsOverviewPage.generateTagLabels(this.filterExcludedTags(tags)));
        this.context.put("chart_data", TagsOverviewPage.generateTagValues(this.filterExcludedTags(tags)));
    }

    static String generateTagLabels(List<TagObject> tagsObjectList) {
        int tagCount = tagsObjectList.size();
        Object[] tagNames = new String[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            tagNames[i] = StringUtils.wrap((String)tagsObjectList.get(i).getName(), (String)"\"");
        }
        return "[" + StringUtils.join((Object[])tagNames, (String)",") + "]";
    }

    private List<TagObject> filterExcludedTags(List<TagObject> tagsObjectList) {
        ArrayList<TagObject> filteredTags = new ArrayList<TagObject>();
        for (TagObject tagObject : tagsObjectList) {
            String tagName = tagObject.getName();
            if (!this.shouldIncludeTag(tagName)) continue;
            filteredTags.add(tagObject);
        }
        return filteredTags;
    }

    private boolean shouldIncludeTag(String tagName) {
        for (Pattern pattern : this.configuration.getTagsToExcludeFromChart()) {
            if (!tagName.matches(pattern.pattern())) continue;
            return false;
        }
        return true;
    }

    static List<String> generateTagValues(List<TagObject> tagsObjectList) {
        int tagsCount = tagsObjectList.size();
        String[][] values = new String[Status.values().length][tagsCount];
        for (int i = 0; i < tagsCount; ++i) {
            TagObject tagObject = tagsObjectList.get(i);
            int allSteps = tagObject.getSteps();
            values[0][i] = TagsOverviewPage.formatAsPercentage(tagObject.getPassedSteps(), allSteps);
            values[1][i] = TagsOverviewPage.formatAsPercentage(tagObject.getFailedSteps(), allSteps);
            values[2][i] = TagsOverviewPage.formatAsPercentage(tagObject.getSkippedSteps(), allSteps);
            values[3][i] = TagsOverviewPage.formatAsPercentage(tagObject.getPendingSteps(), allSteps);
            values[4][i] = TagsOverviewPage.formatAsPercentage(tagObject.getUndefinedSteps(), allSteps);
        }
        ArrayList<String> statuses = new ArrayList<String>();
        for (int i = 0; i < Status.values().length; ++i) {
            statuses.add("[" + StringUtils.join((Object[])values[i], (String)", ") + "]");
        }
        return statuses;
    }

    static String formatAsPercentage(int value, int sum) {
        return DECIMAL_FORMATTER.format(100.0f * (float)value / (float)sum);
    }

    static {
        DECIMAL_FORMATTER.setMinimumFractionDigits(2);
        DECIMAL_FORMATTER.setMaximumFractionDigits(2);
    }
}

