/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class StepObject
implements Comparable<StepObject> {
    public final String location;
    private long totalDuration;
    private int totalOccurrences;
    private final StatusCounter statusCounter = new StatusCounter();

    public StepObject(String location) {
        if (StringUtils.isEmpty((String)location)) {
            throw new ValidationException("Location cannnot be null!");
        }
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void addDuration(long duration, Status status) {
        this.totalDuration += duration;
        ++this.totalOccurrences;
        this.statusCounter.incrementFor(status);
    }

    public long getDurations() {
        return this.totalDuration;
    }

    public String getFormattedTotalDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public long getAverageDuration() {
        return this.totalDuration / (long)this.totalOccurrences;
    }

    public String getFormattedAverageDuration() {
        return Util.formatDuration(this.getAverageDuration());
    }

    public int getTotalOccurrences() {
        return this.totalOccurrences;
    }

    public String getPercentageResult() {
        int total = 0;
        for (Status status : Status.values()) {
            total += this.statusCounter.getValueFor(status);
        }
        return Util.formatAsPercentage(this.statusCounter.getValueFor(Status.PASSED), total);
    }

    public Status getStatus() {
        return this.statusCounter.getFinalStatus();
    }

    @Override
    public int compareTo(StepObject o) {
        return Integer.signum(this.location.compareTo(o.getLocation()));
    }
}

