/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector;

import java.io.File;

public class USBStorageDevice {
    private final File rootDirectory;
    private final String deviceName;
    private final String device;
    private final String uuid;

    public USBStorageDevice(File rootDirectory, String deviceName, String device, String uuid) {
        if (rootDirectory == null || !rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid root file!");
        }
        this.rootDirectory = rootDirectory;
        if (deviceName == null || deviceName.isEmpty()) {
            deviceName = rootDirectory.getName();
        }
        this.device = device;
        this.deviceName = deviceName;
        this.uuid = uuid;
    }

    public boolean canRead() {
        return this.rootDirectory.canRead();
    }

    public boolean canWrite() {
        return this.rootDirectory.canWrite();
    }

    public boolean canExecute() {
        return this.rootDirectory.canExecute();
    }

    public String getSystemDisplayName() {
        String driveLetter = this.rootDirectory.getPath();
        if (driveLetter.endsWith("\\")) {
            driveLetter = driveLetter.substring(0, driveLetter.length() - 1);
        }
        return this.deviceName + " (" + driveLetter + ")";
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDevice() {
        return this.device;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "USBStorageDevice(rootDirectory=" + this.getRootDirectory() + ", deviceName=" + this.getDeviceName() + ", device=" + this.getDevice() + ", uuid=" + this.getUuid() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof USBStorageDevice)) {
            return false;
        }
        USBStorageDevice other = (USBStorageDevice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$rootDirectory = this.getRootDirectory();
        File other$rootDirectory = other.getRootDirectory();
        if (this$rootDirectory == null ? other$rootDirectory != null : !((Object)this$rootDirectory).equals(other$rootDirectory)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        String this$device = this.getDevice();
        String other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof USBStorageDevice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $rootDirectory = this.getRootDirectory();
        result = result * 59 + ($rootDirectory == null ? 43 : ((Object)$rootDirectory).hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        String $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }
}

