/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutputProcessor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(OutputProcessor.class);
    private final BufferedReader input;

    public void processOutput(Consumer<String> method) throws IOException {
        String outputLine;
        while ((outputLine = this.readOutputLine()) != null) {
            method.accept(outputLine);
        }
    }

    public boolean checkOutput(Predicate<String> method) throws IOException {
        String outputLine;
        while ((outputLine = this.readOutputLine()) != null) {
            if (!method.test(outputLine)) continue;
            return true;
        }
        return false;
    }

    private String readOutputLine() throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("You need to call 'executeCommand' method first");
        }
        String outputLine = this.input.readLine();
        if (outputLine != null) {
            return outputLine.trim();
        }
        return null;
    }

    protected void closeInput() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public OutputProcessor(BufferedReader input) {
        this.input = input;
    }
}

