/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.CycleHandlingStrategy;
import net.sf.qualitytest.blueprint.MatchingStrategy;
import net.sf.qualitytest.blueprint.configuration.StrategyPair;
import net.sf.qualitytest.blueprint.strategy.creation.BlueprintCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.SingleValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.CaseInsensitiveMethodNameMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.TypeMatchingStrategy;
import net.sf.qualitytest.exception.BlueprintCycleException;

class ImmutableBlueprintConfiguration
implements BlueprintConfiguration {
    private final List<StrategyPair> mapping;
    private final List<CycleHandlingStrategy<?>> cycleHandling;
    private final boolean withPublicAttributes;

    public ImmutableBlueprintConfiguration() {
        this.mapping = ImmutableList.of();
        this.cycleHandling = ImmutableList.of();
        this.withPublicAttributes = false;
    }

    protected ImmutableBlueprintConfiguration(@Nonnull List<StrategyPair> attributeMapping, @Nonnull List<CycleHandlingStrategy<?>> attributeCycleHandling, boolean withPublicAttributes) {
        Check.notNull(attributeMapping, (String)"attributeMapping");
        Check.notNull(attributeCycleHandling, (String)"attributeCycleHandling");
        this.mapping = ImmutableList.copyOf(attributeMapping);
        this.cycleHandling = ImmutableList.copyOf(attributeCycleHandling);
        this.withPublicAttributes = withPublicAttributes;
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public <T> T construct(@Nonnull Class<T> clazz) {
        return Blueprint.construct(clazz, this, new BlueprintSession());
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public CreationStrategy<?> findCreationStrategyForField(@Nonnull Field field) {
        Check.notNull((Object)field, (String)"field");
        for (StrategyPair entry : Lists.reverse(this.mapping)) {
            if (!entry.getKey().matchesByField(field)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public CreationStrategy<?> findCreationStrategyForMethod(@Nonnull Method method) {
        Check.notNull((Object)method, (String)"method");
        for (StrategyPair entry : Lists.reverse(this.mapping)) {
            if (!entry.getKey().matchesByMethod(method)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public CreationStrategy<?> findCreationStrategyForType(@Nonnull Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        for (StrategyPair entry : Lists.reverse(this.mapping)) {
            if (!entry.getKey().matchesByType(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T handleCycle(@Nonnull BlueprintSession session, @Nonnull Class<T> clazz) {
        for (CycleHandlingStrategy strategy : Lists.reverse(this.cycleHandling)) {
            if (!strategy.isActiveForType(clazz)) continue;
            return strategy.handleCycle(session, clazz);
        }
        throw new BlueprintCycleException(session, clazz);
    }

    @Override
    public boolean isWithPublicAttributes() {
        return this.withPublicAttributes;
    }

    @Override
    @Nonnull
    public <T> BlueprintConfiguration with(@Nonnull Class<T> type, @Nullable CreationStrategy<?> creator) {
        return this.with(new TypeMatchingStrategy(type), creator);
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull Class<T> type, @Nullable T value) {
        return this.with(new TypeMatchingStrategy(type), new SingleValueCreationStrategy<T>(value));
    }

    @Override
    @Throws(value={IllegalNullArgumentException.class})
    @Nonnull
    public <T> BlueprintConfiguration with(@Nonnull CycleHandlingStrategy<T> cycleHandlingStrategy) {
        Check.notNull(cycleHandlingStrategy, (String)"cycleHandlingStrategy");
        ArrayList strategies = new ArrayList();
        strategies.addAll(this.cycleHandling);
        strategies.add(cycleHandlingStrategy);
        return new ImmutableBlueprintConfiguration(this.mapping, strategies, this.withPublicAttributes);
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull MatchingStrategy matchingStrategy) {
        return this.with(matchingStrategy, new BlueprintCreationStrategy());
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public BlueprintConfiguration with(@Nonnull MatchingStrategy matcher, @Nonnull CreationStrategy<?> creator) {
        Check.notNull((Object)matcher, (String)"matcher");
        Check.notNull(creator, (String)"creator");
        ArrayList<StrategyPair> mapping = new ArrayList<StrategyPair>();
        mapping.addAll(this.mapping);
        mapping.add(new StrategyPair(matcher, creator));
        return new ImmutableBlueprintConfiguration(mapping, this.cycleHandling, this.withPublicAttributes);
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull String name, @Nullable T value) {
        Check.notEmpty((CharSequence)name, (String)"name");
        return this.with(new CaseInsensitiveMethodNameMatchingStrategy(name), new SingleValueCreationStrategy<T>(value));
    }

    @Override
    @Nonnull
    public BlueprintConfiguration withPublicAttributes(boolean withPublicAttributes) {
        return new ImmutableBlueprintConfiguration(this.mapping, this.cycleHandling, withPublicAttributes);
    }
}

