/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.creation;

import java.util.UUID;
import javax.annotation.Nonnegative;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.strategy.creation.ValueCreationStrategy;

public class BlueprintStringCreationStrategy
extends ValueCreationStrategy<String> {
    private final int maxLength;

    public BlueprintStringCreationStrategy() {
        this.maxLength = -1;
    }

    @ArgumentsChecked
    public BlueprintStringCreationStrategy(@Nonnegative int maxLength) {
        this.maxLength = Check.notNegative((int)maxLength, (String)"maxLength");
    }

    @Override
    public String createValue(Class<?> expectedClass) {
        String ret = UUID.randomUUID().toString();
        if (this.maxLength >= 0) {
            return ret.substring(0, this.maxLength);
        }
        return ret;
    }
}

