/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.creation;

import java.util.Random;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.qualitytest.blueprint.strategy.creation.ValueCreationStrategy;

public class RandomEnumCreationStrategy
extends ValueCreationStrategy<Enum<?>> {
    private final Random random = new Random();

    @Override
    @Throws(value={IllegalNullArgumentException.class, IllegalStateOfArgumentException.class})
    public Enum<?> createValue(Class<?> expectedClazz) {
        Check.notNull(expectedClazz, (String)"expectedClazz");
        Check.stateIsTrue((boolean)expectedClazz.isEnum(), (String)"Argument 'expectedClazz' must be an enum.");
        Class<?> enumClazz = expectedClazz;
        Enum[] enumConstants = (Enum[])enumClazz.getEnumConstants();
        int index = enumConstants.length > 0 ? this.random.nextInt(enumConstants.length) : -1;
        return enumConstants.length > 0 ? enumConstants[index] : null;
    }
}

