/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemCheckingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AlphaCode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class ItemChecker
extends UnaryExpression {
    private final ItemType requiredItemType;
    private final Supplier<RoleDiagnostic> roleSupplier;

    public ItemChecker(Expression sequence, ItemType itemType, Supplier<RoleDiagnostic> roleSupplier) {
        super(sequence);
        this.requiredItemType = itemType;
        this.roleSupplier = roleSupplier;
    }

    public ItemType getRequiredType() {
        return this.requiredItemType;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public RoleDiagnostic getRoleLocator() {
        return this.roleSupplier.get();
    }

    @Override
    public Expression simplify() throws XPathException {
        Expression operand = this.getBaseExpression().simplify();
        if (this.requiredItemType instanceof AnyItemType) {
            return operand;
        }
        this.setBaseExpression(operand);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        if (operand instanceof Block) {
            Block block = (Block)operand;
            ArrayList<ItemChecker> checkedOperands = new ArrayList<ItemChecker>();
            for (Operand o : block.operands()) {
                ItemChecker checkedOp = new ItemChecker(o.getChildExpression(), this.requiredItemType, this.roleSupplier);
                checkedOperands.add(checkedOp);
            }
            Block newBlock = new Block(checkedOperands.toArray(new Expression[0]));
            ExpressionTool.copyLocationInfo(this, newBlock);
            return newBlock.typeCheck(visitor, contextInfo);
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        int card = operand.getCardinality();
        if (card == 8192) {
            return operand;
        }
        ItemType supplied = operand.getItemType();
        Affinity relation = th.relationship(this.requiredItemType, supplied);
        if (relation == Affinity.SAME_TYPE || relation == Affinity.SUBSUMES) {
            return operand;
        }
        if (relation == Affinity.DISJOINT) {
            if (Cardinality.allowsZero(card)) {
                if (!(operand instanceof Literal)) {
                    RoleDiagnostic role = this.roleSupplier.get();
                    String message = role.composeErrorMessage(this.requiredItemType, operand, th);
                    visitor.getStaticContext().issueWarning("The only value that can pass type-checking is an empty sequence. " + message, "SXWN9026", this.getLocation());
                }
            } else {
                RoleDiagnostic role = this.roleSupplier.get();
                String message = role.composeErrorMessage(this.requiredItemType, operand, th);
                throw new XPathException(message).withErrorCode(role.getErrorCode()).withLocation(this.getLocation()).asTypeErrorIf(role.isTypeError());
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().optimize(visitor, contextInfo);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Affinity rel = th.relationship(this.requiredItemType, this.getBaseExpression().getItemType());
        if (rel == Affinity.SAME_TYPE || rel == Affinity.SUBSUMES) {
            return this.getBaseExpression();
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        int m = 22;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public String getStreamerName() {
        return "ItemChecker";
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    private SequenceIterator checkSequence(SequenceIterator base, XPathContext context) {
        Expression baseExpr = this.getBaseExpression();
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Consumer<Item> checker = item -> {
            if (!this.requiredItemType.matches((Item)item, th)) {
                RoleDiagnostic role = this.roleSupplier.get();
                String message = role.composeErrorMessage(this.requiredItemType, (Item)item, th);
                String errorCode = role.getErrorCode();
                XPathException te = new XPathException(message, errorCode).withFailingExpression(baseExpr).withLocation(baseExpr.getLocation()).asTypeErrorIf(!"XPDY0050".equals(errorCode));
                throw new UncheckedXPathException(te);
            }
        };
        return new ItemCheckingIterator(base, checker);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    public Item checkItem(Item item, XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        if (item == null) {
            return null;
        }
        if (this.requiredItemType.matches(item, th)) {
            return item;
        }
        RoleDiagnostic role = this.roleSupplier.get();
        String message = role.composeErrorMessage(this.requiredItemType, item, th);
        String errorCode = role.getErrorCode();
        if ("XPDY0050".equals(errorCode)) {
            this.dynamicError(message, errorCode, context);
        } else {
            this.typeError(message, errorCode, context);
        }
        return null;
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        ItemChecker.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ItemChecker exp = new ItemChecker(this.getBaseExpression().copy(rebindings), this.requiredItemType, this.roleSupplier);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public ItemType getItemType() {
        ItemType operandType = this.getBaseExpression().getItemType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Affinity relationship = th.relationship(this.requiredItemType, operandType);
        switch (relationship) {
            case OVERLAPS: {
                if (this.requiredItemType instanceof NodeTest && operandType instanceof NodeTest) {
                    return new CombinedNodeTest((NodeTest)this.requiredItemType, 23, (NodeTest)operandType);
                }
                return this.requiredItemType;
            }
            case SUBSUMES: 
            case SAME_TYPE: {
                return operandType;
            }
        }
        return this.requiredItemType;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.fromTypeCode(this.requiredItemType.getPrimitiveType());
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType == ((ItemChecker)other).requiredItemType;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.requiredItemType.hashCode();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("treat", this);
        out.emitAttribute("as", AlphaCode.fromItemType(this.requiredItemType));
        out.emitAttribute("diag", this.roleSupplier.get().save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "treatAs";
    }

    @Override
    public String toString() {
        String typeDesc = this.requiredItemType.toString();
        return "(" + String.valueOf(this.getBaseExpression()) + ") treat as " + typeDesc;
    }

    @Override
    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    @Override
    public Elaborator getElaborator() {
        return new ItemCheckerElaborator();
    }

    public static class ItemCheckerElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            ItemChecker exp = (ItemChecker)this.getExpression();
            Expression arg = exp.getBaseExpression();
            PullEvaluator argEval = arg.makeElaborator().elaborateForPull();
            return context -> exp.checkSequence(argEval.iterate(context), context);
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            ItemChecker expr = (ItemChecker)this.getExpression();
            Expression arg = expr.getBaseExpression();
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            return context -> expr.checkItem(argEval.eval(context), context);
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ItemChecker expr = (ItemChecker)this.getExpression();
            Expression arg = expr.getBaseExpression();
            int card = 57344;
            if (arg instanceof CardinalityChecker) {
                card = ((CardinalityChecker)arg).getRequiredCardinality();
                arg = ((CardinalityChecker)arg).getBaseExpression();
            }
            if ((arg.getImplementationMethod() & 4) != 0 && !(expr.requiredItemType instanceof DocumentNodeTest)) {
                Expression finalArg = arg;
                int finalCard = card;
                return (output, context) -> {
                    PushEvaluator argPush = finalArg.makeElaborator().elaborateForPush();
                    TypeCheckingFilter filter = new TypeCheckingFilter(output);
                    filter.setRequiredType(expr.requiredItemType, finalCard, expr.roleSupplier.get(), expr.getLocation());
                    TailCall tc = argPush.processLeavingTail(filter, context);
                    Expression.dispatchTailCall(tc);
                    filter.finalCheck();
                    return null;
                };
            }
            PullEvaluator argEval = arg.makeElaborator().elaborateForPull();
            return (output, context) -> {
                Item item;
                SequenceIterator iter = expr.checkSequence(argEval.iterate(context), context);
                while ((item = iter.next()) != null) {
                    output.append(item);
                }
                return null;
            };
        }
    }
}

