/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMapper;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualUntypedCopy;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceType;

public class CopyOf
extends Instruction
implements ValidatingInstruction {
    private final Operand selectOp;
    private final boolean copyNamespaces;
    private boolean copyAccumulators;
    private final int validation;
    private final SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private final boolean rejectDuplicateAttributes;
    private final boolean validating;
    private boolean copyLineNumbers = false;
    private boolean copyForUpdate = false;
    private boolean isSchemaAware = true;
    private double invocations = 1.0;
    private double numberOfItems = 20.0;

    public CopyOf(Expression select, boolean copyNamespaces, int validation, SchemaType schemaType, boolean rejectDuplicateAttributes) {
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.copyNamespaces = copyNamespaces;
        this.validation = validation;
        this.schemaType = schemaType;
        this.validating = schemaType != null || validation == 1 || validation == 2;
        this.rejectDuplicateAttributes = rejectDuplicateAttributes;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectOp;
    }

    @Override
    public int getValidationAction() {
        return this.validation;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.isSchemaAware = schemaAware;
    }

    public void setCopyLineNumbers(boolean copy) {
        this.copyLineNumbers = copy;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getSelect().getItemType().isPlainType();
    }

    @Override
    public int getInstructionNameCode() {
        return 147;
    }

    public void setRequireDocumentOrElement(boolean requireDocumentOrElement) {
        this.requireDocumentOrElement = requireDocumentOrElement;
    }

    public boolean isDocumentOrElementRequired() {
        return this.requireDocumentOrElement;
    }

    public void setCopyForUpdate(boolean forUpdate) {
        this.copyForUpdate = forUpdate;
    }

    public boolean isCopyForUpdate() {
        return this.copyForUpdate;
    }

    @Override
    public int getImplementationMethod() {
        return 14;
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    public void setCopyAccumulators(boolean copy) {
        this.copyAccumulators = copy;
    }

    public boolean isCopyAccumulators() {
        return this.copyAccumulators;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CopyOf c = new CopyOf(this.getSelect().copy(rebindings), this.copyNamespaces, this.validation, this.schemaType, this.rejectDuplicateAttributes);
        ExpressionTool.copyLocationInfo(this, c);
        c.setCopyForUpdate(this.copyForUpdate);
        c.setCopyLineNumbers(this.copyLineNumbers);
        c.isSchemaAware = this.isSchemaAware;
        c.setCopyAccumulators(this.copyAccumulators);
        return c;
    }

    @Override
    public ItemType getItemType() {
        ItemType in = this.getSelect().getItemType();
        if (!this.isSchemaAware) {
            return in;
        }
        Configuration config = this.getConfiguration();
        if (this.schemaType != null) {
            TypeHierarchy th = config.getTypeHierarchy();
            Affinity e = th.relationship(in, NodeKindTest.ELEMENT);
            if (e == Affinity.SAME_TYPE || e == Affinity.SUBSUMED_BY) {
                return new ContentTypeTest(1, this.schemaType, config, false);
            }
            Affinity a = th.relationship(in, NodeKindTest.ATTRIBUTE);
            if (a == Affinity.SAME_TYPE || a == Affinity.SUBSUMED_BY) {
                return new ContentTypeTest(2, this.schemaType, config, false);
            }
        } else {
            switch (this.validation) {
                case 3: {
                    return in;
                }
                case 4: {
                    TypeHierarchy th = config.getTypeHierarchy();
                    Affinity e = th.relationship(in, NodeKindTest.ELEMENT);
                    if (e == Affinity.SAME_TYPE || e == Affinity.SUBSUMED_BY) {
                        return new ContentTypeTest(1, Untyped.getInstance(), config, false);
                    }
                    Affinity a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                    if (a == Affinity.SAME_TYPE || a == Affinity.SUBSUMED_BY) {
                        return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, config, false);
                    }
                    if (e != Affinity.DISJOINT || a != Affinity.DISJOINT) {
                        if (in instanceof NodeTest) {
                            return AnyNodeTest.getInstance();
                        }
                        return AnyItemType.getInstance();
                    }
                    return in;
                }
                case 1: 
                case 2: {
                    if (in instanceof NodeTest) {
                        TypeHierarchy th = config.getTypeHierarchy();
                        int fp = ((NodeTest)in).getFingerprint();
                        if (fp != -1) {
                            Affinity e = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e == Affinity.SAME_TYPE || e == Affinity.SUBSUMED_BY) {
                                SchemaDeclaration elem = config.getElementDeclaration(fp);
                                if (elem != null) {
                                    try {
                                        return new ContentTypeTest(1, elem.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                            }
                            Affinity a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == Affinity.SAME_TYPE || a == Affinity.SUBSUMED_BY) {
                                SchemaDeclaration attr = config.getAttributeDeclaration(fp);
                                if (attr != null) {
                                    try {
                                        return new ContentTypeTest(2, attr.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                            }
                        } else {
                            Affinity e = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e == Affinity.SAME_TYPE || e == Affinity.SUBSUMED_BY) {
                                return NodeKindTest.ELEMENT;
                            }
                            Affinity a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == Affinity.SAME_TYPE || a == Affinity.SUBSUMED_BY) {
                                return NodeKindTest.ATTRIBUTE;
                            }
                        }
                        return AnyNodeTest.getInstance();
                    }
                    if (in instanceof AtomicType) {
                        return in;
                    }
                    return AnyItemType.getInstance();
                }
            }
        }
        return this.getSelect().getItemType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.getSelect().getStaticUType(contextItemType);
    }

    @Override
    public int getCardinality() {
        return this.getSelect().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getSelect().getDependencies();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        if (this.isDocumentOrElementRequired()) {
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(2, "validate", 0, "XQTY0030");
            Configuration config = visitor.getConfiguration();
            this.setSelect(config.getTypeChecker(false).staticTypeCheck(this.getSelect(), SequenceType.SINGLE_NODE, role, visitor));
            TypeHierarchy th = config.getTypeHierarchy();
            ItemType t = this.getSelect().getItemType();
            if (th.isSubType(t, NodeKindTest.ATTRIBUTE)) {
                throw new XPathException("validate{} expression cannot be applied to an attribute", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.TEXT)) {
                throw new XPathException("validate{} expression cannot be applied to a text node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.COMMENT)) {
                throw new XPathException("validate{} expression cannot be applied to a comment node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.PROCESSING_INSTRUCTION)) {
                throw new XPathException("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.NAMESPACE)) {
                throw new XPathException("validate{} expression cannot be applied to a namespace node", "XQTY0030");
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.selectOp.optimize(visitor, contextItemType);
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        this.adoptChildExpression(this.getSelect());
        if (this.getSelect().getItemType().isPlainType()) {
            return this.getSelect();
        }
        if (this.getSelect() instanceof Block) {
            Block b1 = (Block)this.getSelect();
            Expression[] splitCopy = new Expression[b1.size()];
            for (int i = 0; i < splitCopy.length; ++i) {
                Expression exp = b1.getOperanda()[i].getChildExpression().copy(new RebindingMap());
                splitCopy[i] = exp.getItemType().isPlainType() ? exp : new CopyOf(exp, this.copyNamespaces, this.validation, this.schemaType, this.rejectDuplicateAttributes);
            }
            return new Block(splitCopy);
        }
        return this;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("copyOf", this);
        if (this.validation != 4) {
            out.emitAttribute("validation", Validation.describe(this.validation));
        }
        if (this.schemaType != null) {
            out.emitAttribute("type", this.schemaType.getStructuredQName());
        }
        StringBuilder fsb = new StringBuilder(16);
        if (this.requireDocumentOrElement) {
            fsb.append('p');
        }
        if (this.rejectDuplicateAttributes) {
            fsb.append('a');
        }
        if (this.validating) {
            fsb.append('v');
        }
        if (this.copyLineNumbers) {
            fsb.append('l');
        }
        if (this.copyForUpdate) {
            fsb.append('u');
        }
        if (this.isSchemaAware) {
            fsb.append('s');
        }
        if (this.copyNamespaces) {
            fsb.append('c');
        }
        if (this.copyAccumulators) {
            fsb.append('m');
        }
        if (fsb.length() != 0) {
            out.emitAttribute("flags", fsb.toString());
        }
        this.getSelect().export(out);
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "CopyOf";
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getItemType();
        if (th.relationship(type, NodeKindTest.ELEMENT) != Affinity.DISJOINT || th.relationship(type, NodeKindTest.DOCUMENT) != Affinity.DISJOINT) {
            result.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    private void copyOneNode(XPathContext context, Outputter out, NodeInfo item, int copyOptions) throws XPathException {
        Controller controller = context.getController();
        boolean copyBaseURI = out.getSystemId() == null;
        int kind = item.getNodeKind();
        if (this.requireDocumentOrElement && kind != 1 && kind != 9) {
            throw new XPathException("Operand of validate expression must be a document or element node").withXPathContext(context).withErrorCode("XQTY0030");
        }
        Configuration config = controller.getConfiguration();
        switch (kind) {
            case 1: {
                Outputter eval = out;
                if (this.validating) {
                    String xsitype;
                    ParseOptions options = new ParseOptions().withSchemaValidationMode(this.validation);
                    SchemaType type = this.schemaType;
                    if (type == null && (this.validation == 1 || this.validation == 2) && (xsitype = item.getAttributeValue(NamespaceUri.SCHEMA_INSTANCE, "type")) != null) {
                        StructuredQName typeName;
                        try {
                            typeName = StructuredQName.fromLexicalQName(xsitype, true, false, item.getAllNamespaces());
                        }
                        catch (XPathException e) {
                            throw new XPathException("Invalid QName in xsi:type attribute of element being validated: " + xsitype + ". " + e.getMessage(), "XTTE1510");
                        }
                        type = config.getSchemaType(typeName);
                        if (type == null) {
                            throw new XPathException("Unknown xsi:type in element being validated: " + xsitype, "XTTE1510");
                        }
                    }
                    options = options.withTopLevelType(type).withTopLevelElement(NameOfNode.makeName(item).getStructuredQName()).withErrorReporter(context.getErrorReporter());
                    config.prepareValidationReporting(context, options);
                    Receiver validator = config.getElementValidator(out, options, this.getLocation());
                    eval = new ComplexContentOutputter(validator);
                }
                if (copyBaseURI) {
                    eval.setSystemId(CopyOf.computeNewBaseUri(item, this.getStaticBaseURIString()));
                }
                PipelineConfiguration pipe = out.getPipelineConfiguration();
                if (this.copyLineNumbers) {
                    LocationCopier copier = new LocationCopier(false, out.getSystemId());
                    pipe.setCopyInformee(CSharp.methodRef(copier::notifyElementNode));
                }
                item.copy(eval, copyOptions, this.getLocation());
                if (!this.copyLineNumbers) break;
                pipe.setCopyInformee(null);
                break;
            }
            case 2: {
                if (this.schemaType != null && this.schemaType.isComplexType()) {
                    XPathException e = new XPathException("When copying an attribute with schema validation, the requested type must not be a complex type").withLocation(this.getLocation()).withXPathContext(context).withErrorCode("XTTE1535");
                    throw CopyOf.dynamicError(this.getLocation(), e, context);
                }
                try {
                    CopyOf.copyAttribute(item, (SimpleType)this.schemaType, this.validation, this, out, context, this.rejectDuplicateAttributes);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e = new XPathException(err.getMessage()).withLocation(this.getLocation()).withXPathContext(context).withErrorCode(err.getErrorCodeQName());
                    throw CopyOf.dynamicError(this.getLocation(), e, context);
                }
            }
            case 3: {
                out.characters(item.getUnicodeStringValue(), this.getLocation(), 0);
                break;
            }
            case 7: {
                if (copyBaseURI) {
                    out.setSystemId(item.getBaseURI());
                }
                out.processingInstruction(item.getDisplayName(), item.getUnicodeStringValue(), this.getLocation(), 0);
                break;
            }
            case 8: {
                out.comment(item.getUnicodeStringValue(), this.getLocation(), 0);
                break;
            }
            case 13: {
                try {
                    out.namespace(item.getLocalPart(), NamespaceUri.of(item.getStringValue()), 0);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e = new XPathException(err.getMessage()).withXPathContext(context).withErrorCode(err.getErrorCodeQName());
                    throw CopyOf.dynamicError(this.getLocation(), e, context);
                }
            }
            case 9: {
                ParseOptions options = new ParseOptions().withSchemaValidationMode(this.validation).withSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance()).withTopLevelType(this.schemaType).withErrorReporter(context.getErrorReporter());
                config.prepareValidationReporting(context, options);
                Receiver val = config.getDocumentValidator(out, item.getBaseURI(), options, this.getLocation());
                if (copyBaseURI) {
                    val.setSystemId(item.getBaseURI());
                }
                PipelineConfiguration savedPipe = null;
                if (this.copyLineNumbers) {
                    savedPipe = new PipelineConfiguration(val.getPipelineConfiguration());
                    LocationCopier copier = new LocationCopier(true, item.getBaseURI());
                    val.getPipelineConfiguration().setCopyInformee(CSharp.methodRef(copier::notifyElementNode));
                }
                item.copy(val, copyOptions, this.getLocation());
                if (!this.copyLineNumbers) break;
                val.setPipelineConfiguration(savedPipe);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + item.getNodeKind());
            }
        }
    }

    public static String computeNewBaseUri(NodeInfo source, String staticBaseURI) {
        String newBaseUri;
        block6: {
            String xmlBase = source.getAttributeValue(NamespaceUri.XML, "base");
            if (xmlBase != null) {
                try {
                    URI xmlBaseUri = new URI(xmlBase);
                    if (xmlBaseUri.isAbsolute()) {
                        newBaseUri = xmlBase;
                        break block6;
                    }
                    if (staticBaseURI != null) {
                        URI sbu = new URI(staticBaseURI);
                        URI abs = sbu.resolve(xmlBaseUri);
                        newBaseUri = abs.toString();
                        break block6;
                    }
                    newBaseUri = source.getBaseURI();
                }
                catch (URISyntaxException err) {
                    newBaseUri = source.getBaseURI();
                }
            } else {
                newBaseUri = source.getBaseURI();
            }
        }
        return newBaseUri;
    }

    public static void copyAttribute(NodeInfo source, SimpleType schemaType, int validation, Instruction instruction, Outputter output, XPathContext context, boolean rejectDuplicates) throws XPathException {
        int opt = rejectDuplicates ? 32 : 0;
        UnicodeString value = source.getUnicodeStringValue();
        SimpleType annotation = CopyOf.validateAttribute(source, schemaType, validation, context);
        try {
            output.attribute(NameOfNode.makeName(source), annotation, value.toString(), instruction.getLocation(), opt);
        }
        catch (XPathException e) {
            if (instruction.getPackageData().getHostLanguage() == HostLanguage.XQUERY && e.hasErrorCode("XTTE0950")) {
                e.setErrorCode("XQTY0086");
            }
            throw e.maybeWithLocation(instruction.getLocation()).maybeWithContext(context);
        }
    }

    public static SimpleType validateAttribute(NodeInfo source, SimpleType schemaType, int validation, XPathContext context) throws XPathException {
        UnicodeString value = source.getUnicodeStringValue();
        SimpleType annotation = BuiltInAtomicType.UNTYPED_ATOMIC;
        if (schemaType != null) {
            if (schemaType.isNamespaceSensitive()) {
                XPathException nsErr = new XPathException("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                nsErr.setErrorCode("XTTE1545");
                throw nsErr;
            }
            ValidationFailure valErr = schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
            if (valErr != null) {
                valErr.setMessage("Attribute being copied does not match the required type. " + valErr.getMessage());
                valErr.setErrorCode("XTTE1510");
                throw valErr.makeException();
            }
            annotation = schemaType;
        } else if (validation == 1 || validation == 2) {
            try {
                annotation = context.getConfiguration().validateAttribute(NameOfNode.makeName(source).getStructuredQName(), value, validation);
            }
            catch (ValidationException e) {
                XPathException err = XPathException.makeXPathException(e);
                err.setErrorCodeQName(e.getErrorCodeQName());
                err.setIsTypeError(true);
                throw err;
            }
        } else if (validation == 3 && !(annotation = (SimpleType)source.getSchemaType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC) && annotation.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            err.setErrorCode(context.getController().getExecutable().getHostLanguage() == HostLanguage.XSLT ? "XTTE0950" : "XQTY0086");
            err.setIsTypeError(true);
            throw err;
        }
        return annotation;
    }

    private boolean mustPush() {
        return this.schemaType != null || this.validation == 2 || this.validation == 1 || this.copyForUpdate;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        PullEvaluator pull = this.makeElaborator().elaborateForPull();
        return pull.iterate(context);
    }

    private ItemMappingIterator makeVirtualCopy(SequenceIterator input, Controller controller, boolean isXSLT) throws XPathException {
        if (this.validation == 3) {
            ItemMapper copier = ItemMapper.of(item -> {
                if (item instanceof NodeInfo) {
                    if (((NodeInfo)item).getTreeInfo().isTyped()) {
                        if (!this.copyNamespaces && ((NodeInfo)item).getNodeKind() == 1) {
                            Sink sink = new Sink(controller.makePipelineConfiguration());
                            ((NodeInfo)item).copy(sink, 4, this.getLocation());
                        }
                        if (((NodeInfo)item).getNodeKind() == 2 && ((SimpleType)((NodeInfo)item).getSchemaType()).isNamespaceSensitive()) {
                            throw new XPathException("Cannot copy an attribute with namespace-sensitive content except as part of its containing element", "XTTE0950");
                        }
                    }
                    VirtualCopy vc = VirtualCopy.makeVirtualCopy((NodeInfo)item);
                    vc.setDropNamespaces(!this.copyNamespaces);
                    vc.getTreeInfo().setCopyAccumulators(this.copyAccumulators);
                    if (isXSLT && this.copyAccumulators) {
                        vc.getTreeInfo().setCopyAccumulators(true);
                        AccumulatorManager am = ((XsltController)controller).getAccumulatorManager();
                        am.setApplicableAccumulators(vc.getTreeInfo(), am.getApplicableAccumulators(((NodeInfo)item).getTreeInfo()));
                    }
                    if (((NodeInfo)item).getNodeKind() == 1) {
                        vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, this.getStaticBaseURIString()));
                    }
                    return vc;
                }
                return item;
            });
            return new ItemMappingIterator(input, copier, true);
        }
        if (this.validation == 4) {
            ItemMapper copier = ItemMapper.of(item -> {
                if (!(item instanceof NodeInfo)) {
                    return item;
                }
                VirtualCopy vc = VirtualUntypedCopy.makeVirtualUntypedTree((NodeInfo)item, (NodeInfo)item);
                if (this.copyAccumulators) {
                    vc.getTreeInfo().setCopyAccumulators(true);
                    AccumulatorManager am = ((XsltController)controller).getAccumulatorManager();
                    am.setApplicableAccumulators(vc.getTreeInfo(), am.getApplicableAccumulators(((NodeInfo)item).getTreeInfo()));
                }
                vc.setDropNamespaces(!this.copyNamespaces);
                if (((NodeInfo)item).getNodeKind() == 1) {
                    vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, this.getStaticBaseURIString()));
                }
                return vc;
            });
            return new ItemMappingIterator(input, copier, true);
        }
        return null;
    }

    @Override
    public Elaborator getElaborator() {
        return new CopyOfElaborator();
    }

    private static class CopyOfElaborator
    extends PushElaborator {
        private CopyOfElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            CopyOf expr = (CopyOf)this.getExpression();
            boolean isXSLT = expr.getRetainedStaticContext().getPackageData().isXSLT();
            if (!(expr.schemaType != null || expr.copyForUpdate || expr.validation != 3 && expr.validation != 4)) {
                PullEvaluator select = expr.getSelect().makeElaborator().elaborateForPull();
                return context -> {
                    Controller controller = context.getController();
                    return expr.makeVirtualCopy(select.iterate(context), controller, isXSLT);
                };
            }
            HostLanguage host = expr.getPackageData().getHostLanguage();
            PushEvaluator push = this.elaborateForPush();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setXPathContext(context);
                SequenceCollector out = new SequenceCollector(pipe, (int)(expr.numberOfItems / expr.invocations));
                if (expr.copyForUpdate) {
                    out.setTreeModel(TreeModel.LINKED_TREE);
                }
                pipe.setHostLanguage(host);
                try {
                    TailCall tc = push.processLeavingTail(new ComplexContentOutputter(out), context);
                    Expression.dispatchTailCall(tc);
                }
                catch (XPathException err) {
                    err.maybeSetLocation(expr.getLocation());
                    err.maybeSetContext(context);
                    throw err;
                }
                GroundedValue result = out.getSequence();
                expr.invocations += 1.0;
                expr.numberOfItems += (double)result.getLength();
                return result.iterate();
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            if (((CopyOf)this.getExpression()).copyForUpdate) {
                PushEvaluator pushEval = this.elaborateForPush();
                return context -> {
                    Controller controller = context.getController();
                    assert (controller != null);
                    SequenceCollector seq = controller.allocateSequenceOutputter(1);
                    seq.setTreeModel(TreeModel.LINKED_TREE);
                    TailCall tc = pushEval.processLeavingTail(new ComplexContentOutputter(seq), context);
                    Expression.dispatchTailCall(tc);
                    seq.close();
                    return seq.getFirstItem();
                };
            }
            return super.elaborateForItem();
        }

        @Override
        public PushEvaluator elaborateForPush() {
            CopyOf expr = (CopyOf)this.getExpression();
            if (expr.copyAccumulators) {
                if (expr.mustPush()) {
                    PullEvaluator selectPull = expr.getSelect().makeElaborator().elaborateForPull();
                    return (output, context) -> {
                        SequenceTool.supply(selectPull.iterate(context), item -> {
                            if (item instanceof NodeInfo) {
                                TinyBuilder builder = new TinyBuilder(output.getPipelineConfiguration());
                                ComplexContentOutputter cco = new ComplexContentOutputter(builder);
                                cco.open();
                                expr.copyOneNode(context, cco, (NodeInfo)item, 2);
                                cco.close();
                                TinyNodeImpl copy = (TinyNodeImpl)builder.getCurrentRoot();
                                copy.getTree().setCopiedFrom((NodeInfo)item);
                                output.append(copy);
                            } else {
                                output.append(item);
                            }
                        });
                        return null;
                    };
                }
                PullEvaluator pull = this.elaborateForPull();
                return (output, context) -> {
                    SequenceTool.supply(pull.iterate(context), output::append);
                    return null;
                };
            }
            int copyOptions = (expr.validation == 4 ? 0 : 4) | (expr.copyNamespaces ? 2 : 0) | (expr.copyForUpdate ? 8 : 0);
            PullEvaluator selectPull = expr.getSelect().makeElaborator().elaborateForPull();
            return (output, context) -> {
                SequenceTool.supply(selectPull.iterate(context), item -> {
                    if (item instanceof NodeInfo) {
                        expr.copyOneNode(context, output, (NodeInfo)item, copyOptions);
                    } else {
                        output.append(item, expr.getLocation(), 524288);
                    }
                });
                return null;
            };
        }
    }
}

