/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.CompareToConstant;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.expr.sort.ContextFreeAtomicComparer;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;

public class GenericAtomicComparer
implements AtomicComparer {
    private StringCollator collator;
    private final transient XPathContext context;

    public GenericAtomicComparer(StringCollator collator, XPathContext conversionContext) {
        this.collator = collator;
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.context = conversionContext;
    }

    public static AtomicComparer makeAtomicComparer(BuiltInAtomicType type0, BuiltInAtomicType type1, StringCollator collator, XPathContext context) {
        int fp1;
        int fp0 = type0.getFingerprint();
        if (fp0 == (fp1 = type1.getFingerprint())) {
            switch (fp0) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new CalendarValueComparer(context);
                }
                case 514: 
                case 515: 
                case 516: 
                case 517: 
                case 527: 
                case 528: 
                case 533: 
                case 633: 
                case 634: {
                    return ContextFreeAtomicComparer.getInstance();
                }
                case 530: 
                case 531: {
                    return EqualityComparer.getInstance();
                }
            }
        }
        if (type0.isPrimitiveNumeric() && type1.isPrimitiveNumeric()) {
            return ContextFreeAtomicComparer.getInstance();
        }
        if (!(fp0 != 513 && fp0 != 631 && fp0 != 529 || fp1 != 513 && fp1 != 631 && fp1 != 529)) {
            if (collator instanceof CodepointCollator) {
                return CodepointCollatingComparer.getInstance();
            }
            return new CollatingAtomicComparer(collator);
        }
        return new GenericAtomicComparer(collator, context);
    }

    private static AtomicComparisonFunction getContextFreeComparisonFunction(int operator) {
        return (a, b, context) -> {
            int comp = ((XPathComparable)((Object)a)).compareTo((XPathComparable)((Object)b));
            return CompareToConstant.interpretComparisonResult(operator, comp);
        };
    }

    private static AtomicComparisonFunction getFloatingPointComparisonFunction(int operator) {
        return (a, b, context) -> {
            if (a.isNaN() || b.isNaN()) {
                return operator == 51;
            }
            int comp = ((XPathComparable)((Object)a)).compareTo((XPathComparable)((Object)b));
            return CompareToConstant.interpretComparisonResult(operator, comp);
        };
    }

    private static int applyPromotion(BuiltInAtomicType type, int version) {
        if (type.isPrimitiveNumeric()) {
            return 517;
        }
        int fp = type.getFingerprint();
        if (fp == 631 || fp == 529) {
            return 513;
        }
        if (fp == 527 && version >= 40) {
            return 528;
        }
        return fp;
    }

    public static AtomicComparisonFunction makeAtomicComparisonFunction(BuiltInAtomicType type0, BuiltInAtomicType type1, StringCollator collator, int operator, boolean allowRecursion, int version) {
        int fp1;
        int fp0 = GenericAtomicComparer.applyPromotion(type0, version);
        if (fp0 == (fp1 = GenericAtomicComparer.applyPromotion(type1, version))) {
            switch (fp0) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return (a, b, context) -> {
                        int comp = ((CalendarValue)a).compareTo((CalendarValue)b, context.getImplicitTimezone());
                        return CompareToConstant.interpretComparisonResult(operator, comp);
                    };
                }
                case 516: 
                case 517: {
                    return GenericAtomicComparer.getFloatingPointComparisonFunction(operator);
                }
                case 514: 
                case 515: 
                case 527: 
                case 528: 
                case 533: 
                case 633: 
                case 634: {
                    return GenericAtomicComparer.getContextFreeComparisonFunction(operator);
                }
                case 530: 
                case 531: {
                    switch (operator) {
                        case 50: {
                            return (a, b, context) -> a.equals(b);
                        }
                        case 51: {
                            return (a, b, context) -> !a.equals(b);
                        }
                    }
                    return (a, b, context) -> {
                        throw new XPathException(String.valueOf(type0) + " values cannot be compared for ordering", "XPTY0004");
                    };
                }
                case 513: {
                    if (collator instanceof CodepointCollator && operator == 50) {
                        return (a, b, context) -> a.equals(b);
                    }
                    if (collator instanceof CodepointCollator && operator == 51) {
                        return (a, b, context) -> !a.equals(b);
                    }
                    return (a, b, context) -> {
                        int comp = collator.compareStrings(a.getUnicodeStringValue(), b.getUnicodeStringValue());
                        return CompareToConstant.interpretComparisonResult(operator, comp);
                    };
                }
            }
        }
        if (type0.isDurationType() && type1.isDurationType()) {
            switch (operator) {
                case 50: {
                    return (a, b, context) -> a.equals(b);
                }
                case 51: {
                    return (a, b, context) -> !a.equals(b);
                }
            }
        }
        if (allowRecursion) {
            BuiltInAtomicType[] firstTimeTypes = new BuiltInAtomicType[2];
            AtomicComparisonFunction[] firstTimeFunction = new AtomicComparisonFunction[1];
            return (a, b, context) -> {
                BuiltInAtomicType at = a.getPrimitiveType();
                BuiltInAtomicType bt = b.getPrimitiveType();
                AtomicComparisonFunction[] atomicComparisonFunctionArray = firstTimeFunction;
                synchronized (firstTimeFunction) {
                    if (firstTimeFunction[0] == null) {
                        AtomicComparisonFunction comparisonFunction;
                        firstTimeFunction[0] = comparisonFunction = GenericAtomicComparer.makeAtomicComparisonFunction(at, bt, collator, operator, false, version);
                        firstTimeTypes[0] = at;
                        firstTimeTypes[1] = bt;
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return comparisonFunction.compare(a, b, context);
                    }
                    if (firstTimeTypes[0] == at && firstTimeTypes[1] == bt) {
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return firstTimeFunction[0].compare(a, b, context);
                    }
                    AtomicComparisonFunction comparisonFunction = GenericAtomicComparer.makeAtomicComparisonFunction(at, bt, collator, operator, false, version);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return comparisonFunction.compare(a, b, context);
                }
            };
        }
        return (a, b, context) -> {
            throw new XPathException("Values are not comparable (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", context);
        };
    }

    @Override
    public StringCollator getCollator() {
        return this.collator;
    }

    @Override
    public GenericAtomicComparer provideContext(XPathContext context) {
        return new GenericAtomicComparer(this.collator, context);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    @Override
    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof StringValue && b instanceof StringValue) {
            return this.collator.compareStrings(a.getUnicodeStringValue(), b.getUnicodeStringValue());
        }
        int implicitTimezone = this.context.getImplicitTimezone();
        XPathComparable ac = a.getXPathComparable(this.collator, implicitTimezone);
        XPathComparable bc = b.getXPathComparable(this.collator, implicitTimezone);
        if (ac == null || bc == null) {
            XPathException e = new XPathException("Objects are not comparable (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004");
            throw new ComparisonException(e);
        }
        return ac.compareTo(bc);
    }

    @Override
    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a instanceof StringValue && b instanceof StringValue) {
            return this.collator.comparesEqual(a.getUnicodeStringValue(), b.getUnicodeStringValue());
        }
        if (a instanceof CalendarValue && b instanceof CalendarValue) {
            return ((CalendarValue)a).compareTo((CalendarValue)b, this.context.getImplicitTimezone()) == 0;
        }
        int implicitTimezone = this.context.getImplicitTimezone();
        AtomicMatchKey ac = a.getXPathMatchKey(this.collator, implicitTimezone);
        AtomicMatchKey bc = b.getXPathMatchKey(this.collator, implicitTimezone);
        return ac.equals(bc);
    }

    public XPathContext getContext() {
        return this.context;
    }

    @Override
    public String save() {
        return "GAC|" + this.collator.getCollationURI();
    }

    public int hashCode() {
        return this.collator.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GenericAtomicComparer && this.collator.equals(((GenericAtomicComparer)obj).collator);
    }

    @FunctionalInterface
    public static interface AtomicComparisonFunction {
        public boolean compare(AtomicValue var1, AtomicValue var2, XPathContext var3) throws XPathException;
    }
}

