/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.function.Function;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.IrregularGroupFormatter;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class FormatInteger
extends SystemFunction
implements StatefulSystemFunction {
    private static final RegularExpression badDecimalHashPattern = ARegularExpression.compile("(([\\dXx]+|\\w+)#+.*)|(#+[^\\dXx]+)", "");
    private static final RegularExpression modifierPattern = ARegularExpression.compile("([co](\\(.*\\))?)?[at]?", "");
    private static final RegularExpression decimalDigitPattern = ARegularExpression.compile("^((\\p{Nd}|#|[^\\p{N}\\p{L}])+?)$", "");
    private static final RegularExpression nonDecimalDigitPattern = ARegularExpression.compile("^(([Xx#]|[^\\p{N}\\p{L}])+?)$", "");
    public static final String preface = "In the picture string for format-integer, ";
    private Function<IntegerValue, String> formatter = null;

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        boolean opt = true;
        if (!(arguments[1] instanceof Literal)) {
            opt = false;
        }
        if (arguments.length == 3 && !(arguments[2] instanceof Literal)) {
            opt = false;
        }
        if (!opt) {
            return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
        }
        Configuration config = visitor.getConfiguration();
        String language = arguments.length == 3 ? ((StringLiteral)arguments[2]).getGroundedValue().getStringValue() : config.getDefaultLanguage();
        Numberer numb = config.makeNumberer(language, null);
        boolean allow40 = visitor.getStaticContext().getPackageData().getHostLanguageVersion() >= 40;
        this.formatter = this.makeFormatter(numb, ((StringLiteral)arguments[1]).getGroundedValue().getStringValue(), allow40);
        return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.formatInteger((IntegerValue)arguments[0].head(), (StringValue)arguments[1].head(), arguments.length == 2 ? null : (StringValue)arguments[2].head(), context);
    }

    private StringValue formatInteger(IntegerValue num, StringValue picture, StringValue language, XPathContext context) throws XPathException {
        boolean allow40;
        Configuration config = context.getConfiguration();
        boolean bl = allow40 = this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() >= 40;
        if (num == null) {
            return StringValue.EMPTY_STRING;
        }
        Function<IntegerValue, String> localFormatter = this.formatter;
        if (localFormatter == null) {
            String languageVal = language != null ? language.getStringValue() : config.getDefaultLanguage();
            Numberer numb = config.makeNumberer(languageVal, null);
            localFormatter = this.makeFormatter(numb, picture.getStringValue(), allow40);
        }
        try {
            return new StringValue(localFormatter.apply(num));
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    private Function<IntegerValue, String> makeFormatter(Numberer numb, String pic, boolean allow40) throws XPathException {
        String ordinalValue;
        Object letterValue;
        String modifier;
        String primaryToken;
        int lastSemicolon;
        if (pic.isEmpty()) {
            throw new XPathException("In the picture string for format-integer, the picture cannot be empty", "FODF1310");
        }
        boolean hasExplicitRadix = false;
        int radix = 10;
        if (allow40 && pic.matches("^([2-9]|[12][0-9]|3[0-6])\\^.*[xX].*$")) {
            int hat = pic.indexOf(94);
            radix = Integer.parseInt(pic.substring(0, hat));
            hasExplicitRadix = true;
            pic = pic.substring(hat + 1);
        }
        if ((lastSemicolon = pic.lastIndexOf(59)) >= 0) {
            primaryToken = pic.substring(0, lastSemicolon);
            if (primaryToken.isEmpty()) {
                throw new XPathException("In the picture string for format-integer, the primary format token cannot be empty", "FODF1310");
            }
            String string = modifier = lastSemicolon < pic.length() - 1 ? pic.substring(lastSemicolon + 1) : "";
            if (!modifierPattern.matches(StringView.tidy(modifier))) {
                throw new XPathException("In the picture string for format-integer, the modifier is invalid", "FODF1310");
            }
        } else {
            primaryToken = pic;
            modifier = "";
        }
        boolean cardinal = modifier.startsWith("c");
        boolean ordinal = modifier.startsWith("o");
        boolean alphabetic = modifier.endsWith("a");
        int leftParen = modifier.indexOf(40);
        int rightParen = modifier.lastIndexOf(41);
        String parenthetical = leftParen < 0 ? "" : modifier.substring(leftParen + 1, rightParen);
        Object object = letterValue = alphabetic ? "alphabetic" : "traditional";
        String string = ordinal ? ("".equals(parenthetical) ? "yes" : parenthetical) : (ordinalValue = "");
        String cardinalValue = cardinal ? ("".equals(parenthetical) ? "yes" : parenthetical) : "";
        UnicodeString primary = StringView.tidy(primaryToken);
        Categories.Category isDecimalDigit = Categories.getCategory("Nd");
        boolean isDecimalDigitPattern = false;
        if (hasExplicitRadix) {
            if (!nonDecimalDigitPattern.matches(primary)) {
                throw new XPathException("In the picture string for format-integer, the primary format token with radix " + radix + " does not meet the rules for a non-decimal digit pattern", "FODF1310");
            }
            letterValue = (primary.indexOf(88) >= 0L ? "X" : "x") + radix;
        } else {
            IntIterator iter = primary.codePoints();
            while (iter.hasNext()) {
                if (!isDecimalDigit.test(iter.next())) continue;
                isDecimalDigitPattern = true;
                break;
            }
            if (isDecimalDigitPattern && !decimalDigitPattern.matches(primary)) {
                throw new XPathException("In the picture string for format-integer, the primary format token contains a decimal digit but does not meet the rules for a decimal digit pattern", "FODF1310");
            }
        }
        if (isDecimalDigitPattern || hasExplicitRadix) {
            NumericGroupFormatter picGroupFormat = FormatInteger.getPicSeparators(primary, hasExplicitRadix);
            UnicodeString adjustedPicture = picGroupFormat.getAdjustedPicture();
            Object finalLetterValue = letterValue;
            return arg_0 -> FormatInteger.lambda$makeFormatter$0(numb, adjustedPicture, picGroupFormat, (String)finalLetterValue, ordinalValue, arg_0);
        }
        UnicodeString token = StringView.tidy(primaryToken);
        Object finalLetterValue = letterValue;
        return arg_0 -> FormatInteger.lambda$makeFormatter$1(numb, token, (String)finalLetterValue, cardinalValue, ordinalValue, arg_0);
    }

    public static NumericGroupFormatter getPicSeparators(UnicodeString picExpanded, boolean hasExplicitRadix) throws XPathException {
        IntHashSet groupingPositions = new IntHashSet(5);
        ArrayList<Integer> separatorList = new ArrayList<Integer>();
        int groupingPosition = 0;
        int firstGroupingPos = 0;
        int lastGroupingPos = 0;
        boolean regularCheck = true;
        int zeroDigit = -1;
        if (badDecimalHashPattern.matches(picExpanded)) {
            throw new XPathException("In the picture string for format-integer, the picture is not valid (it uses '#' where disallowed)", "FODF1310");
        }
        block8: for (long i = picExpanded.length() - 1L; i >= 0L; --i) {
            int codePoint = picExpanded.codePointAt(i);
            switch (Character.getType(codePoint)) {
                case 9: {
                    if (zeroDigit == -1) {
                        zeroDigit = Alphanumeric.getDigitFamily(codePoint);
                    } else if (zeroDigit != Alphanumeric.getDigitFamily(codePoint)) {
                        throw new XPathException("In the picture string for format-integer, the picture mixes digits from different digit families", "FODF1310");
                    }
                    ++groupingPosition;
                    continue block8;
                }
                case 1: 
                case 2: {
                    if (!hasExplicitRadix) continue block8;
                    if (codePoint == 120 || codePoint == 88) {
                        if (zeroDigit == -1) {
                            zeroDigit = codePoint;
                        } else if (zeroDigit != codePoint) {
                            throw new XPathException("In the picture string for format-integer, the picture mixes upper-case and lower-case non-decimal digits", "FODF1310");
                        }
                    } else {
                        throw new XPathException("In the picture string for format-integer, non-decimal digits must be indicated by 'x' or 'X'", "FODF1310");
                    }
                    ++groupingPosition;
                    continue block8;
                }
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    continue block8;
                }
                default: {
                    if (i == picExpanded.length() - 1L) {
                        throw new XPathException("In the picture string for format-integer, the picture cannot end with a separator", "FODF1310");
                    }
                    if (codePoint == 35) {
                        ++groupingPosition;
                        if (i == 0L) continue block8;
                        switch (Character.getType(picExpanded.codePointAt(i - 1L))) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 5: 
                            case 9: 
                            case 10: 
                            case 11: {
                                throw new XPathException("In the picture string for format-integer, the picture cannot contain alphanumeric character(s) before character '#'", "FODF1310");
                            }
                        }
                        continue block8;
                    }
                    boolean added = ((IntSet)groupingPositions).add(groupingPosition);
                    if (!added) {
                        throw new XPathException("In the picture string for format-integer, the picture contains consecutive separators", "FODF1310");
                    }
                    separatorList.add(codePoint);
                    if (((IntSet)groupingPositions).size() == 1) {
                        firstGroupingPos = groupingPosition;
                    } else {
                        if (groupingPosition != firstGroupingPos * ((IntSet)groupingPositions).size()) {
                            regularCheck = false;
                        }
                        if ((Integer)separatorList.get(0) != codePoint) {
                            regularCheck = false;
                        }
                    }
                    if (i == 0L) {
                        throw new XPathException("In the picture string for format-integer, the picture cannot begin with a separator", "FODF1310");
                    }
                    lastGroupingPos = groupingPosition;
                }
            }
        }
        if (regularCheck && ((IntSet)groupingPositions).size() >= 1 && picExpanded.length() - (long)lastGroupingPos - (long)((IntSet)groupingPositions).size() > (long)firstGroupingPos) {
            regularCheck = false;
        }
        UnicodeString adjustedPic = FormatInteger.extractSeparators(picExpanded, groupingPositions);
        if (((IntSet)groupingPositions).isEmpty()) {
            return new RegularGroupFormatter(0, "", adjustedPic);
        }
        if (regularCheck) {
            if (separatorList.isEmpty()) {
                return new RegularGroupFormatter(0, "", adjustedPic);
            }
            StringBuilder sb = new StringBuilder(4);
            sb.appendCodePoint((Integer)separatorList.get(0));
            return new RegularGroupFormatter(firstGroupingPos, sb.toString(), adjustedPic);
        }
        return new IrregularGroupFormatter(groupingPositions, separatorList, adjustedPic);
    }

    private static UnicodeString extractSeparators(UnicodeString arr, IntSet excludePositions) {
        UnicodeBuilder ub = new UnicodeBuilder(arr.length32());
        IntIterator iter = arr.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            if (!NumberFormatter.isLetterOrDigit(c)) continue;
            ub.append(c);
        }
        return ub.toUnicodeString();
    }

    @Override
    public SystemFunction copy() {
        FormatInteger fi2 = (FormatInteger)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        fi2.formatter = this.formatter;
        return fi2;
    }

    private static /* synthetic */ String lambda$makeFormatter$1(Numberer numb, UnicodeString token, String finalLetterValue, String cardinalValue, String ordinalValue, IntegerValue num) {
        try {
            String s = numb.format(num.abs().longValue(), token, null, finalLetterValue, cardinalValue, ordinalValue);
            return num.signum() < 0 ? "-" + s : s;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    private static /* synthetic */ String lambda$makeFormatter$0(Numberer numb, UnicodeString adjustedPicture, NumericGroupFormatter picGroupFormat, String finalLetterValue, String ordinalValue, IntegerValue num) {
        try {
            String s = numb.format(num.abs().longValue(), adjustedPicture, picGroupFormat, finalLetterValue, "", ordinalValue);
            return num.signum() < 0 ? "-" + s : s;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }
}

