/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLForEachGroup
extends StyleElement {
    private Expression select = null;
    private Expression groupBy = null;
    private Expression groupAdjacent = null;
    private Expression splitWhen = null;
    private Pattern starting = null;
    private Pattern ending = null;
    private Expression collationName;
    private boolean composite = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected void prepareAttributes() {
        int c;
        String groupByAtt = null;
        String groupAdjacentAtt = null;
        String startingAtt = null;
        String endingAtt = null;
        String splitWhenAtt = null;
        String collationAtt = null;
        block24: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            switch (f) {
                case "select": {
                    this.select = this.makeExpression(value, att);
                    continue block24;
                }
                case "group-by": {
                    groupByAtt = value;
                    this.groupBy = this.makeExpression(groupByAtt, att);
                    continue block24;
                }
                case "group-adjacent": {
                    groupAdjacentAtt = value;
                    this.groupAdjacent = this.makeExpression(groupAdjacentAtt, att);
                    continue block24;
                }
                case "group-starting-with": {
                    startingAtt = value;
                    continue block24;
                }
                case "group-ending-with": {
                    endingAtt = value;
                    continue block24;
                }
                case "break-when": {
                    if (!this.requireXslt40Attribute("break-when")) continue block24;
                    splitWhenAtt = "function($group as item()*, $next as item()) as Q{http://www.w3.org/2001/XMLSchema}boolean { Q{http://www.w3.org/2005/xpath-functions}boolean(" + value + ") }";
                    this.splitWhen = this.makeExpression(splitWhenAtt, att);
                    continue block24;
                }
                case "split-when": {
                    if (!this.requireXslt40Attribute("split-when")) continue block24;
                    splitWhenAtt = "function($group as item()*, $next as item()) as Q{http://www.w3.org/2001/XMLSchema}boolean { Q{http://www.w3.org/2005/xpath-functions}boolean(" + value + ") }";
                    this.splitWhen = this.makeExpression(splitWhenAtt, att);
                    continue block24;
                }
                case "collation": {
                    collationAtt = Whitespace.trim(value);
                    this.collationName = this.makeAttributeValueTemplate(collationAtt, att);
                    continue block24;
                }
                case "composite": {
                    this.composite = this.processBooleanAttribute("composite", value);
                    continue block24;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.select == null) {
            this.select = Literal.makeEmptySequence();
            this.reportAbsence("select");
        }
        if ((c = (groupByAtt == null ? 0 : 1) + (groupAdjacentAtt == null ? 0 : 1) + (startingAtt == null ? 0 : 1) + (endingAtt == null ? 0 : 1) + (splitWhenAtt == null ? 0 : 1)) != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified", "XTSE1080");
        }
        if (startingAtt != null) {
            this.starting = this.makePattern(startingAtt, "group-starting-with");
        }
        if (endingAtt != null) {
            this.ending = this.makePattern(endingAtt, "group-ending-with");
        }
        if (collationAtt != null) {
            if (this.groupBy == null && this.groupAdjacent == null) {
                this.compileError("A collation may be specified only if group-by or group-adjacent is specified", "XTSE1090");
            } else if (this.collationName instanceof StringLiteral) {
                String collation = ((StringLiteral)this.collationName).stringify();
                try {
                    URI collationURI = new URI(collation);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        this.collationName = new StringLiteral(collationURI.toString());
                    }
                }
                catch (URISyntaxException err) {
                    this.compileError("Collation name '" + String.valueOf(this.collationName) + "' is not a valid URI", "XTDE1110");
                    this.collationName = new StringLiteral("http://www.w3.org/2005/xpath-functions/collation/codepoint");
                }
            }
        } else {
            String defaultCollation = this.getDefaultCollationName();
            if (defaultCollation != null) {
                this.collationName = new StringLiteral(defaultCollation);
            }
        }
        if (this.composite && (this.starting != null || this.ending != null)) {
            this.compileError("The composite attribute cannot be used with " + (this.starting == null ? "grouping-ending-with" : "group-starting-with"), "XTSE1090");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        Supplier<RoleDiagnostic> role;
        this.checkSortComesFirst(false);
        TypeChecker tc = this.getConfiguration().getTypeChecker(false);
        this.select = this.typeCheck("select", this.select);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        if (this.groupBy != null) {
            this.groupBy = this.typeCheck("group-by", this.groupBy);
            try {
                role = () -> new RoleDiagnostic(4, "xsl:for-each-group/group-by", 0);
                this.groupBy = tc.staticTypeCheck(this.groupBy, SequenceType.ATOMIC_SEQUENCE, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (this.groupAdjacent != null) {
            this.groupAdjacent = this.typeCheck("group-adjacent", this.groupAdjacent);
            try {
                role = () -> new RoleDiagnostic(4, "xsl:for-each-group/group-adjacent", 0, "XTTE1100");
                this.groupAdjacent = tc.staticTypeCheck(this.groupAdjacent, this.composite ? SequenceType.ATOMIC_SEQUENCE : SequenceType.SINGLE_ATOMIC, role, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (this.splitWhen != null) {
            this.splitWhen = this.typeCheck("break-when", this.splitWhen);
            try {
                SpecificFunctionType breakWhenType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.SINGLE_ITEM}, SequenceType.SINGLE_BOOLEAN);
                Supplier<RoleDiagnostic> role2 = () -> new RoleDiagnostic(4, "xsl:for-each-group/break-when", 0, "XTTE1100");
                this.splitWhen = tc.staticTypeCheck(this.splitWhen, SequenceType.makeSequenceType(breakWhenType, 16384), role2, visitor);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        this.starting = this.typeCheck("group-starting-with", this.starting);
        this.ending = this.typeCheck("group-ending-with", this.ending);
        if ((this.starting != null || this.ending != null) && visitor.getStaticContext().getXPathVersion() < 30) {
            try {
                role = () -> new RoleDiagnostic(4, "xsl:for-each-group/select", 0, "XTTE1120");
                this.select = tc.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, role, visitor);
            }
            catch (XPathException err) {
                String prefix = this.starting != null ? "With group-starting-with attribute: " : "With group-ending-with attribute: ";
                this.compileError(prefix + err.getMessage(), err.getErrorCodeQName());
            }
        }
        if (!this.hasChildNodes()) {
            this.issueWarning("An empty xsl:for-each-group instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        StringCollator collator = null;
        if (this.collationName instanceof StringLiteral) {
            String uri = ((StringLiteral)this.collationName).stringify();
            try {
                collator = this.findCollation(uri, this.getBaseURI());
            }
            catch (XPathException err) {
                this.compileError("Failed to load collation " + uri + ": " + err.getMessage(), "XTDE1110");
                collator = CodepointCollator.getInstance();
            }
            if (collator == null) {
                this.compileError("The collation name '" + uri + "' has not been defined", "XTDE1110");
                collator = CodepointCollator.getInstance();
            }
        }
        byte algorithm = 0;
        Expression key = null;
        if (this.groupBy != null) {
            algorithm = 0;
            key = this.groupBy;
        } else if (this.groupAdjacent != null) {
            algorithm = 1;
            key = this.groupAdjacent;
        } else if (this.starting != null) {
            algorithm = 2;
            key = this.starting;
        } else if (this.ending != null) {
            algorithm = 3;
            key = this.ending;
        } else if (this.splitWhen != null) {
            algorithm = 4;
            key = this.splitWhen;
        }
        Expression action = this.compileSequenceConstructor(compilation, decl, true);
        if (action == null) {
            return Literal.makeEmptySequence();
        }
        try {
            ForEachGroup instr = new ForEachGroup(this.select, action.simplify(), algorithm, key, collator, this.collationName, this.makeSortKeys(compilation, decl));
            instr.setIsInFork(this.getParent().getFingerprint() == 159);
            instr.setComposite(this.composite);
            instr.setLocation(this.saveLocation());
            return instr;
        }
        catch (XPathException e) {
            this.compileError(e);
            return null;
        }
    }
}

