/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.math.BigDecimal;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.NumericValue;

public class Timer {
    private static final DayTimeDurationValue milliSecond = new DayTimeDurationValue(1, 0, 0, 0, 0L, 1000);
    private final long start;
    private long prev;

    public Timer() {
        this.prev = this.start = System.nanoTime();
    }

    public static String showExecutionTimeNano(long nanosecs) {
        if ((double)nanosecs < 1.0E9) {
            return (double)nanosecs / 1000000.0 + "ms";
        }
        try {
            double millisecs = (double)nanosecs / 1000000.0;
            DayTimeDurationValue d = milliSecond.multiply(millisecs);
            long days = ((NumericValue)d.getComponent(AccessorFn.Component.DAY)).longValue();
            long hours = ((NumericValue)d.getComponent(AccessorFn.Component.HOURS)).longValue();
            long minutes = ((NumericValue)d.getComponent(AccessorFn.Component.MINUTES)).longValue();
            BigDecimal seconds = ((NumericValue)d.getComponent(AccessorFn.Component.SECONDS)).getDecimalValue();
            StringBuilder fsb = new StringBuilder(256);
            if (days > 0L) {
                fsb.append(days + "days ");
            }
            if (hours > 0L) {
                fsb.append(hours + "h ");
            }
            if (minutes > 0L) {
                fsb.append(minutes + "m ");
            }
            fsb.append(String.valueOf(seconds) + "s");
            return fsb.toString() + " (" + (double)nanosecs / 1000000.0 + "ms)";
        }
        catch (XPathException e) {
            return (double)nanosecs / 1000000.0 + "ms";
        }
    }

    public static String showMemoryUsed() {
        long value = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return "Memory used: " + value / 1000000L + "Mb";
    }

    public void report(String label) {
        long time = System.nanoTime();
        System.err.println(label + " " + (double)(time - this.prev) / 1000000.0 + "ms");
        this.prev = time;
    }

    public void reportCumulative(String label) {
        long time = System.nanoTime();
        System.err.println(label + " " + (double)(time - this.start) / 1000000.0 + "ms");
        this.prev = time;
    }
}

