/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class EnumerationType
implements AtomicType {
    private Set<String> values;

    public EnumerationType(Set<String> values) {
        this.values = values;
    }

    @Override
    public ValidationFailure validate(AtomicValue primValue, UnicodeString lexicalValue, ConversionRules rules) {
        if (primValue.getPrimitiveType() == BuiltInAtomicType.STRING && this.values.contains(primValue.getStringValue())) {
            return null;
        }
        return new ValidationFailure("The string '" + primValue.getStringValue() + " is not valid for the enumeration type " + this.toString());
    }

    @Override
    public boolean isOrdered(boolean optimistic) {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public StructuredQName getTypeName() {
        return new StructuredQName("", NamespaceUri.ANONYMOUS, "E" + this.hashCode());
    }

    @Override
    public double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public StringConverter getStringConverter(ConversionRules rules) {
        return new StringToEnumConverter(this);
    }

    @Override
    public List<? extends PlainType> getPlainMemberTypes() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof AtomicValue && ((AtomicValue)item).getPrimitiveType() == BuiltInAtomicType.STRING && this.values.contains(item.getStringValue());
    }

    @Override
    public AtomicType getPrimitiveItemType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public int getPrimitiveType() {
        return 513;
    }

    @Override
    public UType getUType() {
        return UType.STRING;
    }

    @Override
    public PlainType getAtomizedItemType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        return true;
    }

    @Override
    public String getBasicAlphaCode() {
        return "E";
    }

    @Override
    public boolean isAtomicType() {
        return true;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public AtomicSequence getTypedValue(UnicodeString value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        return new StringValue(value);
    }

    @Override
    public ValidationFailure validateContent(UnicodeString value, NamespaceResolver nsResolver, ConversionRules rules) {
        return null;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public int getWhitespaceAction() {
        return 0;
    }

    @Override
    public UnicodeString preprocess(UnicodeString input) throws ValidationException {
        return input;
    }

    @Override
    public UnicodeString postprocess(UnicodeString input) throws ValidationException {
        return input;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public NamespaceUri getTargetNamespace() {
        return null;
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeName().getDisplayName();
    }

    @Override
    public StructuredQName getStructuredQName() {
        return null;
    }

    @Override
    public String getEQName() {
        return null;
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAnonymousType() {
        return true;
    }

    @Override
    public int getBlock() {
        return 0;
    }

    @Override
    public SchemaType getBaseType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int getDerivationMethod() {
        return 1;
    }

    @Override
    public int getFinalProhibitions() {
        return 0;
    }

    @Override
    public boolean allowsDerivation(int derivation) {
        return true;
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
        BuiltInAtomicType.STRING.analyzeContentExpression(expression, kind);
    }

    @Override
    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        return null;
    }

    @Override
    public boolean isSameType(SchemaType other) {
        return other instanceof EnumerationType && this.values.equals(((EnumerationType)other).values);
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public String toString() {
        StringBuilder fsb = new StringBuilder(256);
        fsb.append("enum(");
        for (String st : this.values) {
            char delim = '\"';
            if (st.indexOf(34) >= 0) {
                delim = st.indexOf(39) > 0 ? (char)'`' : '\'';
            }
            fsb.append(delim).append(st).append(delim).append(", ");
        }
        fsb.setLength(fsb.length() - 2);
        fsb.append(")");
        return fsb.toString();
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType base, int block) throws SchemaException {
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public SchemaValidationStatus getValidationStatus() {
        return SchemaValidationStatus.VALIDATED;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    private static class StringToEnumConverter
    extends StringConverter {
        private final EnumerationType enumType;

        public StringToEnumConverter(EnumerationType enumType) {
            this.enumType = enumType;
        }

        @Override
        public ConversionResult convertString(UnicodeString input) {
            if (this.enumType.values.contains(input.toString())) {
                return new StringValue(input, (AtomicType)this.enumType);
            }
            return new ValidationFailure("'" + String.valueOf(input) + "' is not a valid value for the required enumeration type");
        }
    }
}

