/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Whitespace;

public class Base64BinaryValue
extends AtomicValue
implements AtomicMatchKey,
XPathComparable,
ContextFreeAtomicValue {
    private final byte[] binaryValue;
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] encoding = new int[64];
    private static final int[] decoding = new int[128];

    public Base64BinaryValue(UnicodeString s) throws XPathException {
        super(BuiltInAtomicType.BASE64_BINARY);
        this.binaryValue = Base64BinaryValue.decode(s);
    }

    public Base64BinaryValue(byte[] value) {
        super(BuiltInAtomicType.BASE64_BINARY);
        this.binaryValue = value;
    }

    public Base64BinaryValue(byte[] value, AtomicType typeLabel) {
        super(typeLabel);
        this.binaryValue = value;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new Base64BinaryValue(this.binaryValue, typeLabel);
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BASE64_BINARY;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        return Base64BinaryValue.encode(this.binaryValue);
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Base64BinaryValue && Arrays.equals(this.binaryValue, ((Base64BinaryValue)other).binaryValue);
    }

    @Override
    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    protected static int byteArrayHashCode(byte[] value) {
        long h = 0L;
        for (int i = 0; i < Math.min(value.length, 64); ++i) {
            h = h << 1 ^ (long)value[i];
        }
        return (int)(h >> 32 ^ h);
    }

    public static UnicodeString encode(byte[] value) {
        int val;
        UnicodeBuilder buff = new UnicodeBuilder(value.length * 2);
        int whole = value.length - value.length % 3;
        for (int i = 0; i < whole; i += 3) {
            val = ((value[i] & 0xFF) << 16) + ((value[i + 1] & 0xFF) << 8) + (value[i + 2] & 0xFF);
            buff.append((char)encoding[val >> 18 & 0x3F]);
            buff.append((char)encoding[val >> 12 & 0x3F]);
            buff.append((char)encoding[val >> 6 & 0x3F]);
            buff.append((char)encoding[val & 0x3F]);
        }
        int remainder = value.length % 3;
        switch (remainder) {
            default: {
                break;
            }
            case 1: {
                val = (value[whole] & 0xFF) << 4;
                buff.append((char)encoding[val >> 6 & 0x3F]);
                buff.append((char)encoding[val & 0x3F]);
                buff.appendLatin("==");
                break;
            }
            case 2: {
                val = ((value[whole] & 0xFF) << 10) + ((value[whole + 1] & 0xFF) << 2);
                buff.append((char)encoding[val >> 12 & 0x3F]);
                buff.append((char)encoding[val >> 6 & 0x3F]);
                buff.append((char)encoding[val & 0x3F]);
                buff.append("=");
                break;
            }
        }
        return buff.toUnicodeString();
    }

    public static byte[] decode(UnicodeString in) throws XPathException {
        in = in.tidy();
        int[] unit = new int[4];
        byte[] result = new byte[in.length32()];
        int bytesUsed = 0;
        int i = 0;
        int u = 0;
        int pad = 0;
        int chars = 0;
        char last = '\u0000';
        while ((long)i < in.length()) {
            int c;
            if (!Whitespace.isWhite(c = in.codePointAt(i++))) {
                ++chars;
                if (c == 61) {
                    pad = 1;
                    int k = i;
                    while ((long)k < in.length()) {
                        int ch = in.codePointAt(k);
                        if (ch == 61) {
                            ++pad;
                            ++chars;
                        } else if (!Whitespace.isWhite(ch)) {
                            throw new XPathException("Base64 padding character '=' is followed by non-padding characters", "FORG0001");
                        }
                        ++k;
                    }
                    if (pad == 1 && "AEIMQUYcgkosw048".indexOf(last) < 0) {
                        throw new XPathException("In base64, if the value ends with a single '=' character, then the preceding character must be one of [AEIMQUYcgkosw048]", "FORG0001");
                    }
                    if (pad == 2 && "AQgw".indexOf(last) < 0) {
                        throw new XPathException("In base64, if the value ends with '==', then the preceding character must be one of [AQgw]", "FORG0001");
                    }
                    if (pad > 2) {
                        throw new XPathException("Found " + pad + " '=' characters at end of base64 value; max is 2", "FORG0001");
                    }
                    if (pad != (4 - u) % 4) {
                        throw new XPathException("Required " + (4 - u) % 4 + " '=' characters at end of base64 value; found " + pad, "FORG0001");
                    }
                    for (int p = 0; p < pad; ++p) {
                        unit[u++] = 65;
                    }
                    i = in.length32();
                } else {
                    last = (char)c;
                    unit[u++] = c;
                }
                if (u == 4) {
                    int t = (Base64BinaryValue.decodeChar(unit[0]) << 18) + (Base64BinaryValue.decodeChar(unit[1]) << 12) + (Base64BinaryValue.decodeChar(unit[2]) << 6) + Base64BinaryValue.decodeChar(unit[3]);
                    if (bytesUsed + 3 > result.length) {
                        byte[] r2 = new byte[bytesUsed * 2];
                        System.arraycopy(result, 0, r2, 0, bytesUsed);
                        result = r2;
                    }
                    result[bytesUsed++] = (byte)(t >> 16 & 0xFF);
                    result[bytesUsed++] = (byte)(t >> 8 & 0xFF);
                    result[bytesUsed++] = (byte)(t & 0xFF);
                    u = 0;
                }
            }
            if ((long)i < in.length()) continue;
            bytesUsed -= pad;
            break;
        }
        if (chars % 4 != 0) {
            throw new XPathException("Length of base64 value must be a multiple of four", "FORG0001");
        }
        byte[] r3 = new byte[bytesUsed];
        System.arraycopy(result, 0, r3, 0, bytesUsed);
        return r3;
    }

    private static int decodeChar(int c) throws XPathException {
        int d;
        int n = d = c < 128 ? decoding[c] : -1;
        if (d == -1) {
            throw new XPathException("Invalid character '" + c + "' in base64 value", "FORG0001");
        }
        return d;
    }

    @Override
    public int compareTo(XPathComparable o) {
        if (o instanceof HexBinaryValue) {
            o = new Base64BinaryValue(((HexBinaryValue)o).getBinaryValue());
        }
        if (o instanceof Base64BinaryValue) {
            byte[] other = ((Base64BinaryValue)o).binaryValue;
            int len0 = this.binaryValue.length;
            int len1 = other.length;
            int shorter = Math.min(len0, len1);
            for (int i = 0; i < shorter; ++i) {
                int a = this.binaryValue[i] & 0xFF;
                int b = other[i] & 0xFF;
                if (a == b) continue;
                return a < b ? -1 : 1;
            }
            return Integer.signum(len0 - len1);
        }
        throw new ClassCastException("Cannot compare xs:base64Binary to " + String.valueOf(o.getClass()));
    }

    static {
        Arrays.fill(decoding, -1);
        int i = 0;
        while (i < alphabet.length()) {
            char c = alphabet.charAt(i);
            Base64BinaryValue.encoding[i] = c;
            Base64BinaryValue.decoding[c] = i++;
        }
    }
}

